<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 19,
  'name' => 'Tips',
  'slug' => 'tips',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 23,
  'name' => 'Trends',
  'slug' => 'trends',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 24,
  'name' => 'Fashion',
  'slug' => 'fashion',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 25,
  'name' => 'News',
  'slug' => 'news',
  'term_group' => 0,
  'taxonomy' => 'category',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Office',
  'slug' => 'office',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Casual',
  'slug' => 'casual',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Sporty',
  'slug' => 'sporty',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 26,
  'name' => 'Accessories',
  'slug' => 'accessories',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 21,
  'name' => 'About',
  'slug' => 'about',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 22,
  'name' => 'Customer Support',
  'slug' => 'customer-support',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 253,
  'post_date' => '2018-09-28 19:01:05',
  'post_date_gmt' => '2018-09-28 19:01:05',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.

<span id="more-818"></span>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio.',
  'post_title' => 'A fantastic outfit for active men',
  'post_excerpt' => '',
  'post_name' => 'a-fantastic-outfit-for-active-men',
  'post_modified' => '2018-09-10 19:03:35',
  'post_modified_gmt' => '2018-09-10 19:03:35',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=253',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"p0f3880\\"}],\\"element_id\\":\\"cu7y030\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'fashion, trends',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/man-with-brown-bag-leather.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 54,
  'post_date' => '2018-09-09 17:01:14',
  'post_date_gmt' => '2018-09-09 17:01:14',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Tips to Choose Sunglasses for Men',
  'post_excerpt' => '',
  'post_name' => 'tips-to-choose-sunglasses-for-men',
  'post_modified' => '2018-09-10 19:31:43',
  'post_modified_gmt' => '2018-09-10 19:31:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=54',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"yckt210\\"}],\\"element_id\\":\\"0pif043\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-sunglasess.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 47,
  'post_date' => '2018-09-08 03:21:55',
  'post_date_gmt' => '2018-09-08 03:21:55',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-371"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'How to Look Official But Stylish',
  'post_excerpt' => '',
  'post_name' => 'how-to-look-official-but-stylish',
  'post_modified' => '2018-09-10 18:58:05',
  'post_modified_gmt' => '2018-09-10 18:58:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=47',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    'layout' => 'sidebar-none',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"ko7w053\\"}],\\"element_id\\":\\"pxy0500\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/handsome-model-long-hair.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 239,
  'post_date' => '2018-09-07 18:06:16',
  'post_date_gmt' => '2018-09-07 18:06:16',
  'post_content' => 'Labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum. Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-401"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.',
  'post_title' => 'Men\'s Bag Trend for Winter',
  'post_excerpt' => '',
  'post_name' => 'mens-bag-trend-for-winter',
  'post_modified' => '2018-09-10 19:17:09',
  'post_modified_gmt' => '2018-09-10 19:17:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=239',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"2nwl901\\"}],\\"element_id\\":\\"69ko190\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/PeopleImages.com-ID1580371.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 218,
  'post_date' => '2018-09-06 17:17:24',
  'post_date_gmt' => '2018-09-06 17:17:24',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.<span id="more-382"></span>

<span id="more-117"></span>Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat epellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.

. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur? voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus.',
  'post_title' => 'A Men\'s Guide to the Scarf',
  'post_excerpt' => '',
  'post_name' => 'a-mens-guide-to-the-scarf',
  'post_modified' => '2018-09-22 15:13:40',
  'post_modified_gmt' => '2018-09-22 15:13:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=218',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"57d9de7\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"05ba3c6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-model-in-park-with-bike.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 210,
  'post_date' => '2018-09-05 17:12:24',
  'post_date_gmt' => '2018-09-05 17:12:24',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate.<span id="more-371"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.',
  'post_title' => 'How to Achieve the Skater Style With Ease',
  'post_excerpt' => '',
  'post_name' => 'how-to-achieve-the-skater-style-with-ease',
  'post_modified' => '2018-09-10 18:58:25',
  'post_modified_gmt' => '2018-09-10 18:58:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=210',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"zjcy030\\"}],\\"element_id\\":\\"vvxg600\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'tips, trends',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-model-with-skate-outfit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 215,
  'post_date' => '2018-09-04 17:13:54',
  'post_date_gmt' => '2018-09-04 17:13:54',
  'post_content' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.recusandae. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.<span id="more-378"></span>

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores.',
  'post_title' => 'Street Casual Fashion',
  'post_excerpt' => '',
  'post_name' => 'street-casual-fashion',
  'post_modified' => '2018-09-10 18:58:32',
  'post_modified_gmt' => '2018-09-10 18:58:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=215',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5w3c002\\"}],\\"element_id\\":\\"2zw8704\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'trends',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-model-with-bike.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 227,
  'post_date' => '2018-09-03 17:21:15',
  'post_date_gmt' => '2018-09-03 17:21:15',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<span id="more-397"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt neque porro quisquam.',
  'post_title' => 'Ralph Lauren New Collection',
  'post_excerpt' => '',
  'post_name' => 'ralph-lauren-new-collection',
  'post_modified' => '2018-09-10 19:12:36',
  'post_modified_gmt' => '2018-09-10 19:12:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=227',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"m8ir000\\"}],\\"element_id\\":\\"xh0q590\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/stylish-working-outfit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 234,
  'post_date' => '2018-09-02 18:02:42',
  'post_date_gmt' => '2018-09-02 18:02:42',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-406"></span>

inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Stylish Coat Collection From Paul Smith',
  'post_excerpt' => '',
  'post_name' => 'stylish-coat-collection-from-paul-smith',
  'post_modified' => '2018-09-10 18:58:43',
  'post_modified_gmt' => '2018-09-10 18:58:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=234',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"s55x845\\"}],\\"element_id\\":\\"3ojd575\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'fashion, trends',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/man-going-to-work.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 243,
  'post_date' => '2018-09-01 18:09:53',
  'post_date_gmt' => '2018-09-01 18:09:53',
  'post_content' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatu.

At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis.',
  'post_title' => 'Tips to Choose Men\'s Jeans Shirt',
  'post_excerpt' => '',
  'post_name' => 'tips-to-choose-mens-jeans-shirt',
  'post_modified' => '2018-09-10 18:58:52',
  'post_modified_gmt' => '2018-09-10 18:58:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=243',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"xr5n120\\"}],\\"element_id\\":\\"rhcc185\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'fashion, news, tips',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/PeopleImages.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 222,
  'post_date' => '2018-08-29 17:20:04',
  'post_date_gmt' => '2018-08-29 17:20:04',
  'post_content' => 'Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates.<span id="more-393"></span>

Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur?”  repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis.',
  'post_title' => 'Stylish and Elegant Fashion for Men',
  'post_excerpt' => '',
  'post_name' => 'stylish-and-elegant-fashion-for-men',
  'post_modified' => '2018-09-10 18:59:04',
  'post_modified_gmt' => '2018-09-10 18:59:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=222',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"29yn032\\"}],\\"element_id\\":\\"rr57772\\"}]',
  ),
  'tax_input' => 
  array (
    'category' => 'fashion, trends',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-model-with-cigar.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 247,
  'post_date' => '2018-08-10 18:56:49',
  'post_date_gmt' => '2018-08-10 18:56:49',
  'post_content' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.<span id="more-412"></span>

Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae.',
  'post_title' => 'Best Ethical Brands to Wear for Work',
  'post_excerpt' => '',
  'post_name' => 'best-ethical-brands-to-wear-for-work',
  'post_modified' => '2018-09-21 20:41:16',
  'post_modified_gmt' => '2018-09-21 20:41:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=247',
  'menu_order' => 0,
  'post_type' => 'post',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3dc2bc5\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"5f4ede8\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
    'category' => 'news',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-working.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 146,
  'post_date' => '2018-09-01 15:56:00',
  'post_date_gmt' => '2018-09-01 15:56:00',
  'post_content' => '<!--themify_builder_static--><h1>About us</h1> <h2>Radically engineered suit clothes</h2> 
<h3>History<br/></h3>
 <p>We started Ministry of Supply to solve the problems of stiff, high-maintenance dress clothes by engineering high-performing, comfortable apparel.</p> 
 <ul> <li id="timeline-0">
 2010 
 
 <h2>Shoppe Men</h2> <figure> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/timeline-shoppe-men.jpg" alt="Shoppe Men" /> </figure> <h3>Vecture Begins...</h3> <p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s,</p> 
 </li>
 <li id="timeline-1">
 2011 
 
 <h2>Launched the first collection</h2> <figure> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/shoppe-men-2011.jpg" alt="Launched the first collection" /> </figure> <h3>Designed &amp; Tailored in house</h3> <p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s,</p> 
 </li>
 <li id="timeline-2">
 2017 
 
 <h2>Expanded</h2> <figure> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/shoppe-men-2017.jpg" alt="Expanded" /> </figure> <h3>Full collections over 100+ Styles</h3> <p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\'s standard dummy text ever since the 1500s,</p> 
 </li>
 <li id="timeline-3">
 2018 
 
 <h2></h2> 
 </li>
 </ul> 
<h3>Services<br/></h3>
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/measuring-100x80.png" width="100" height="80" title="measuring body" alt="measuring body" /> <h3> measuring body </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/Custom-style-100x80.png" width="100" height="80" title="Custom style" alt="Custom style" /> <h3> Custom style </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/sewing-clothes-100x80.png" width="100" height="80" title="Sewing Clothes" alt="Sewing Clothes" /> <h3> Sewing Clothes </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/stylish-fashion-100x80.png" width="100" height="80" title="Stylish Fashion" alt="Stylish Fashion" /> <h3> Stylish Fashion </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/sell-product-100x80.png" width="100" height="80" title="Sell Product" alt="Sell Product" /> <h3> Sell Product </h3> 
<h3>Our Team<br/></h3>
 <p>We started Ministry of Supply to solve the problems of stiff, high-maintenance with our staff.</p> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/natasha-500x600.jpg" width="500" height="600" title="Natasha Sarasvati" alt="Fashion Designer" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/09/natasha-500x600.jpg 500w, https://themify.me/demo/themes/shoppe-men/files/2018/09/natasha-249x300.jpg 249w, https://themify.me/demo/themes/shoppe-men/files/2018/09/natasha.jpg 380w" sizes="(max-width: 500px) 100vw, 500px" /> <h3> Natasha Sarasvati </h3> Fashion Designer 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/james-500x600.jpg" width="500" height="600" title="James Franciszek" alt="Sales and Marketing" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/09/james-500x600.jpg 500w, https://themify.me/demo/themes/shoppe-men/files/2018/09/james-249x300.jpg 249w, https://themify.me/demo/themes/shoppe-men/files/2018/09/james.jpg 380w" sizes="(max-width: 500px) 100vw, 500px" /> <h3> James Franciszek </h3> Sales and Marketing 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/francois-500x600.jpg" width="500" height="600" title="Francois Atambua" alt="Creative Director" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/09/francois-500x600.jpg 500w, https://themify.me/demo/themes/shoppe-men/files/2018/09/francois-249x300.jpg 249w, https://themify.me/demo/themes/shoppe-men/files/2018/09/francois.jpg 380w" sizes="(max-width: 500px) 100vw, 500px" /> <h3> Francois Atambua </h3> Creative Director 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/jonathan-500x600.jpg" width="500" height="600" title="Jonathan Vladyslav" alt="Fashion Designer" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/09/jonathan-500x600.jpg 500w, https://themify.me/demo/themes/shoppe-men/files/2018/09/jonathan-249x300.jpg 249w, https://themify.me/demo/themes/shoppe-men/files/2018/09/jonathan.jpg 380w" sizes="(max-width: 500px) 100vw, 500px" /> <h3> Jonathan Vladyslav </h3> Fashion Designer<!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2018-09-25 13:10:09',
  'post_modified_gmt' => '2018-09-25 13:10:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?page_id=146',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2af335c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8270a01\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bec745f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_h1\\":\\"#ffffff\\",\\"font_size_h1\\":\\"18\\",\\"text_transform_h1\\":\\"uppercase\\",\\"font_color_h2\\":\\"#ffffff\\",\\"font_size_h2\\":\\"36\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>About us<\\\\/h1>\\\\n<h2>Radically engineered suit clothes<\\\\/h2>\\"}}]},{\\"element_id\\":\\"0484cd7\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/about-top.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"f9dcb21\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"e189feb\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"38e33e5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"History\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"06d3d26\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"0079119\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\"},{\\"element_id\\":\\"2fdcb99\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\"}]},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a7c656d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#23282e\\",\\"font_size\\":\\"30\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>We started Ministry of Supply to solve the problems of stiff, high-maintenance dress clothes by engineering high-performing, comfortable apparel.<\\\\/p>\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"d7ec941\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"5e82fcc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"timeline\\",\\"element_id\\":\\"3ecf030\\",\\"mod_settings\\":{\\"background_color\\":\\"#ffffff\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"template_timeline\\":\\"list\\",\\"source_timeline\\":\\"text\\",\\"category_post_timeline\\":\\"0|multiple\\",\\"post_per_page_post_timeline\\":\\"4\\",\\"order_post_timeline\\":\\"desc\\",\\"orderby_post_timeline\\":\\"date\\",\\"display_post_timeline\\":\\"excerpt\\",\\"hide_feat_img_post_timeline\\":\\"no\\",\\"text_source_timeline\\":[{\\"title_timeline\\":\\"Shoppe Men\\",\\"date_timeline\\":\\"2010\\",\\"image_timeline\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/timeline-shoppe-men.jpg\\",\\"content_timeline\\":\\"<h3>Vecture Begins...<\\\\/h3>\\\\n<p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\\\\\\\\\'s standard dummy text ever since the 1500s,<\\\\/p>\\"},{\\"title_timeline\\":\\"Launched the first collection\\",\\"date_timeline\\":\\"2011\\",\\"image_timeline\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/shoppe-men-2011.jpg\\",\\"content_timeline\\":\\"<h3>Designed &amp; Tailored in house<\\\\/h3>\\\\n<p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\\\\\\\\\'s standard dummy text ever since the 1500s,<\\\\/p>\\"},{\\"title_timeline\\":\\"Expanded\\",\\"date_timeline\\":\\"2017\\",\\"image_timeline\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/shoppe-men-2017.jpg\\",\\"content_timeline\\":\\"<h3>Full collections over 100+ Styles<\\\\/h3>\\\\n<p>We’re creating a new category of clothing. We call it “performance professional.” We re-invent sharp, classic styles in materials that synchronize with the human body. Lorem Ipsum is simply dummy text of the printing and typesetting industry. Lorem Ipsum has been the industry\\\\\\\\\\\'s standard dummy text ever since the 1500s,<\\\\/p>\\"},{\\"date_timeline\\":\\"2018\\"}],\\"breakpoint_mobile\\":{\\"padding_top_unit\\":\\"%\\",\\"margin_bottom\\":\\"20\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"20\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"2af335c\\",\\"unstick_when_el_mod_id\\":\\"bec745f\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"e071020\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"a026958\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"212c4f7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Services\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-left\\"}},{\\"element_id\\":\\"0fb7b50\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"0ecbfdc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b84d747\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#23282e\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"font_size_title\\":\\"18\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/measuring.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"80\\",\\"title_image\\":\\"measuring body\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#e5585e\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"83b09bb\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"8d8a128\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#23282e\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"font_size_title\\":\\"18\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/Custom-style.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"80\\",\\"title_image\\":\\"Custom style\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#e5585e\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\"}}]},{\\"element_id\\":\\"869db0f\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"3b73678\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b3ad400\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#23282e\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"font_size_title\\":\\"18\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/sewing-clothes.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"80\\",\\"title_image\\":\\"Sewing Clothes\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#e5585e\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"f3fca71\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"9173311\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#23282e\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"font_size_title\\":\\"18\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/stylish-fashion.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"80\\",\\"title_image\\":\\"Stylish Fashion\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#e5585e\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}}]}]},{\\"element_id\\":\\"ff8a60b\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"2943c49\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"978b62e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"743a39d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_title\\":\\"#23282e\\",\\"font_color_title_hover\\":\\"#ffffff\\",\\"font_size_title\\":\\"18\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/sell-product.png\\",\\"width_image\\":\\"100\\",\\"height_image\\":\\"80\\",\\"title_image\\":\\"Sell Product\\",\\"param_image\\":\\"regular\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#ffffff\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"cover_color_hover\\":\\"#e5585e\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"a23cd24\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"margin_bottom\\":\\"20\\",\\"border-type\\":\\"top\\"}}],\\"col_tablet\\":\\"column4-2\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/services.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"30\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-narrow\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"3923082\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"2a28e00\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\"},{\\"element_id\\":\\"7c45aa0\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\"}]},{\\"element_id\\":\\"30d9437\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"0a0b829\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"1021771\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Our Team\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a4054b3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color\\":\\"#23282e\\",\\"font_size\\":\\"30\\",\\"line_height\\":\\"1.5\\",\\"line_height_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>We started Ministry of Supply to solve the problems of stiff, high-maintenance with our staff.<\\\\/p>\\"}},{\\"element_id\\":\\"db44d0d\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"346feff\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"69fc87d\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"#e65563_0\\",\\"b_c_c_h\\":\\"#e65761_0.90\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/natasha.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"title_image\\":\\"Natasha Sarasvati\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Fashion Designer\\",\\"css_image\\":\\"our-team\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f100cb7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"#e65761_0\\",\\"b_c_c_h\\":\\"#e5585e_0.90\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/james.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"title_image\\":\\"James Franciszek\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Sales and Marketing\\",\\"css_image\\":\\"our-team\\"}}]},{\\"element_id\\":\\"71e5ede\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b287fa5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"20\\",\\"margin_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"#e65563_0\\",\\"b_c_c_h\\":\\"#e65761_0.90\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/francois.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"title_image\\":\\"Francois Atambua\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Creative Director\\",\\"css_image\\":\\"our-team\\"}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4dba622\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"30\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"text_transform_title\\":\\"uppercase\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"#e65761_0\\",\\"b_c_c_h\\":\\"#e5585e_0.90\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/jonathan.jpg\\",\\"width_image\\":\\"500\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"600\\",\\"title_image\\":\\"Jonathan Vladyslav\\",\\"param_image\\":\\"regular\\",\\"caption_image\\":\\"Fashion Designer\\",\\"css_image\\":\\"our-team\\"}}]}],\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"c08111b\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"266ccd3\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 101,
  'post_date' => '2018-08-23 06:17:51',
  'post_date_gmt' => '2018-08-23 06:17:51',
  'post_content' => '',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2018-09-21 20:49:59',
  'post_modified_gmt' => '2018-09-21 20:49:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?page_id=101',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'query_category' => '0',
    'layout' => 'grid3',
    'display_content' => 'none',
    'image_width' => '270',
    'image_height' => '0',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ca87fc4\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"6077d55\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 24,
  'post_date' => '2018-08-23 02:29:42',
  'post_date_gmt' => '2018-08-23 02:29:42',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2018-08-23 02:29:42',
  'post_modified_gmt' => '2018-08-23 02:29:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 25,
  'post_date' => '2018-08-23 02:29:42',
  'post_date_gmt' => '2018-08-23 02:29:42',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2018-08-23 02:29:42',
  'post_modified_gmt' => '2018-08-23 02:29:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 103,
  'post_date' => '2018-08-23 06:18:26',
  'post_date_gmt' => '2018-08-23 06:18:26',
  'post_content' => '<!--themify_builder_static--><h1>Contact</h1> <h2>Design your own suit</h2>
<h3></h3><iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=Toronto&amp;t=m&amp;z=15&amp;output=embed&amp;iwloc=near"></iframe>

<p>32 Old Burlington St, London W1S 3AT, United Kingdom</p>

<p>support@shoppe-men.com<br />info@shoppe-men.com</p>

<p>+44 21 8691 1140</p>
<h3>Contact Us<br/></h3>
<form action="https://themify.me/demo/themes/shoppe-men/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-07-10 08:59:39',
  'post_modified_gmt' => '2019-07-10 08:59:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?page_id=103',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"6820d81\\",\\"cols\\":[{\\"element_id\\":\\"48495cd\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5763d34\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_h1\\":\\"#ffffff\\",\\"font_size_h1\\":\\"18\\",\\"text_transform_h1\\":\\"uppercase\\",\\"font_color_h2\\":\\"#ffffff\\",\\"font_size_h2\\":\\"36\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\\\n<h2>Design your own suit<\\\\/h2>\\",\\"stick_at_position\\":\\"top\\"}}]},{\\"element_id\\":\\"5ff31c6\\",\\"grid_class\\":\\"col4-2\\"}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/09\\\\/bg-contact-header.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color\\":\\"#000000_0.28\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"12\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"12\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"b8f8aeb\\",\\"cols\\":[{\\"element_id\\":\\"48d7b2c\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"map\\",\\"element_id\\":\\"11b4f96\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"map_display_type\\":\\"dynamic\\",\\"address_map\\":\\"Toronto\\",\\"zoom_map\\":\\"15\\",\\"w_map\\":\\"100\\",\\"w_map_unit\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"450\\",\\"type_map\\":\\"ROADMAP\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"draggable_disable_mobile_map\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unit_w\\":\\"-1\\",\\"unit_h\\":\\"-1\\",\\"map_control\\":\\"yes\\",\\"map_provider\\":\\"google\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth-content\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"f954b17\\",\\"cols\\":[{\\"element_id\\":\\"ee99e5a\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"971ea55\\",\\"cols\\":[{\\"element_id\\":\\"828c0f9\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"e63ef1c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#c0a477\\",\\"f_s_i\\":\\"2\\",\\"f_s_i_unit\\":\\"em\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"ti-location-pin\\",\\"icon_color_bg\\":\\"red\\",\\"link_options\\":\\"regular\\"}],\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"aeaa052\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>32 Old Burlington St, London W1S 3AT, United Kingdom<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#e6e6e6\\",\\"border_right_width\\":\\"1\\"}},{\\"element_id\\":\\"940198a\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"9il9782\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#c0a477\\",\\"f_s_i\\":\\"2\\",\\"f_s_i_unit\\":\\"em\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"ti-email\\",\\"icon_color_bg\\":\\"red\\",\\"link_options\\":\\"regular\\"}],\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"io62783\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>support@shoppe-men.com<br \\\\/>info@shoppe-men.com<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"breakpoint_tablet\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"5\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"right\\",\\"border_right_color\\":\\"#ebebeb\\",\\"border_right_width\\":\\"1\\"}},{\\"element_id\\":\\"efcb49c\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"ob2k784\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_size\\":\\"1\\",\\"font_size_unit\\":\\"em\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#c0a477\\",\\"f_s_i\\":\\"2\\",\\"f_s_i_unit\\":\\"em\\",\\"icon_size\\":\\"large\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_vertical\\",\\"content_icon\\":[{\\"icon\\":\\"ti-mobile\\",\\"icon_color_bg\\":\\"red\\",\\"link_options\\":\\"regular\\"}],\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"h2fk784\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>+44 21 8691 1140<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"a0639da\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"2\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Contact Us\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"stick_at_position\\":\\"top\\",\\"inline_text\\":\\"\\"}},{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"01b2add\\",\\"mod_settings\\":{\\"font_size\\":\\"0.9\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_right\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"border_inputs-type\\":\\"top\\",\\"border_send-type\\":\\"top\\",\\"checkbox_padding_success_message_apply_all\\":\\"1\\",\\"checkbox_margin_success_message_apply_all\\":\\"1\\",\\"border_success_message-type\\":\\"top\\",\\"checkbox_padding_error_message_apply_all\\":\\"1\\",\\"checkbox_margin_error_message_apply_all\\":\\"1\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"animated-label\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send\\",\\"field_send_align\\":\\"left\\",\\"stick_at_position\\":\\"top\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fafafa\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_layout\\":\\"zig-zag\\",\\"bottom-frame_color\\":\\"#ffffff\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height\\":\\"50\\",\\"bottom-frame_repeat\\":\\"2\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"14\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin_top\\":\\"-90\\",\\"margin_right\\":\\"50\\",\\"margin_left\\":\\"50\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"#e6e6e6\\",\\"border_top_width\\":\\"1\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_bottom\\":\\"11\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_width\\":\\"fullwidth\\",\\"stick_at_position\\":\\"top\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2018-08-22 16:22:04',
  'post_date_gmt' => '2018-08-22 16:22:04',
  'post_content' => '<!--themify_builder_static--><a href="https://www.youtube.com/watch?v=DaSkMWVlFUU"> </a> 
<h3>New Arrivals<br/></h3>
 <ul data-width="285" data-height="182">
 <li data-product-id="272"> <figure ><a href="https://themify.me/demo/themes/shoppe-men/product/mens-grey-suit/"><img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-grey-suit-with-tie-1024x640-285x182.jpg" width="285" height="182" alt="mens-grey-suit-with-tie" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-men/product/mens-grey-suit/"> <h3>Men&#8217;s Grey Suit</h3> &#36;156.00 </a> <a href="/demo/themes/shoppe-men/wp-admin/admin-ajax.php?add-to-cart=272" data-quantity="1" data-product_id="272" data-product_sku="" aria-label="Add &ldquo;Men&#039;s Grey Suit&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-men/wp-admin/post.php?post=272&#038;action=edit">Edit</a>] <a data-id="272" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-men/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=272"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-men/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-men/product/mens-grey-suit/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit&#038;text=Men%E2%80%99s+Grey+Suit\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit&#038;t=Men%E2%80%99s+Grey+Suit&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit&#038;description=Men%E2%80%99s+Grey+Suit&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Ffiles%2F2018%2F09%2Fmens-grey-suit-with-tie.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-grey-suit&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="275"> <figure >Sale<a href="https://themify.me/demo/themes/shoppe-men/product/mens-winter-scarf/"><img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-scraf-1024x640-285x182.jpg" width="285" height="182" alt="mens-scraf" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-men/product/mens-winter-scarf/"> <h3>Men&#8217;s Winter Scarf</h3> <del>&#36;80.00</del> <ins>&#36;65.00</ins> </a> <a href="/demo/themes/shoppe-men/wp-admin/admin-ajax.php?add-to-cart=275" data-quantity="1" data-product_id="275" data-product_sku="" aria-label="Add &ldquo;Men&#039;s Winter Scarf&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-men/wp-admin/post.php?post=275&#038;action=edit">Edit</a>] <a data-id="275" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-men/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=275"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-men/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-men/product/mens-winter-scarf/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf&#038;text=Men%E2%80%99s+Winter+Scarf\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf&#038;t=Men%E2%80%99s+Winter+Scarf&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf&#038;description=Men%E2%80%99s+Winter+Scarf&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Ffiles%2F2018%2F09%2Fmens-scraf.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-winter-scarf&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="277"> <figure ><a href="https://themify.me/demo/themes/shoppe-men/product/mens-brown-hoodie-jacket/"><img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-jacket-1024x640-285x182.jpg" width="285" height="182" alt="mens-jacket" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-men/product/mens-brown-hoodie-jacket/"> <h3>Men&#8217;s Brown Hoodie Jacket</h3> &#36;125.00 </a> <a href="/demo/themes/shoppe-men/wp-admin/admin-ajax.php?add-to-cart=277" data-quantity="1" data-product_id="277" data-product_sku="" aria-label="Add &ldquo;Men&#039;s Brown Hoodie Jacket&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-men/wp-admin/post.php?post=277&#038;action=edit">Edit</a>] <a data-id="277" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-men/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=277"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-men/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-men/product/mens-brown-hoodie-jacket/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket&#038;text=Men%E2%80%99s+Brown+Hoodie+Jacket\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket&#038;t=Men%E2%80%99s+Brown+Hoodie+Jacket&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket&#038;description=Men%E2%80%99s+Brown+Hoodie+Jacket&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Ffiles%2F2018%2F09%2Fmens-jacket.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-brown-hoodie-jacket&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="280"> <figure >Sale<a href="https://themify.me/demo/themes/shoppe-men/product/mens-light-brown-suit/"><img src="https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-light-brown-suit-1024x640-285x182.jpg" width="285" height="182" alt="mens-light-brown-suit" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-men/product/mens-light-brown-suit/"> <h3>Men&#8217;s Light Brown Suit</h3> <del>&#36;250.00</del> <ins>&#36;225.00</ins> </a> <a href="/demo/themes/shoppe-men/wp-admin/admin-ajax.php?add-to-cart=280" data-quantity="1" data-product_id="280" data-product_sku="" aria-label="Add &ldquo;Men&#039;s Light Brown Suit&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-men/wp-admin/post.php?post=280&#038;action=edit">Edit</a>] <a data-id="280" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-men/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=280"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-men/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-men/product/mens-light-brown-suit/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit&#038;text=Men%E2%80%99s+Light+Brown+Suit\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit&#038;t=Men%E2%80%99s+Light+Brown+Suit&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit&#038;description=Men%E2%80%99s+Light+Brown+Suit&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Ffiles%2F2018%2F09%2Fmens-light-brown-suit.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-men%2Fproduct%2Fmens-light-brown-suit&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> </ul>
 
 <a href="https://themify.me/" >Shop Now</a> 
<h3>Tips and News<br/></h3>
 <a href="https://themify.me/demo/themes/shoppe-men/blog/" >Show All</a> 
<h3>Our Process<br/></h3>
 <a href="https://themify.me/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/tailor-570x276.jpg" width="570" title="How it Works" alt="How it Works" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/tailor.jpg 570w, https://themify.me/demo/themes/shoppe-men/files/2018/08/tailor-300x145.jpg 300w" sizes="(max-width: 570px) 100vw, 570px" /> </a> <h3> <a href="https://themify.me/" > How it Works </a> </h3> 
 <a href="https://themify.me/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/fashion-hang-570x276.jpg" width="570" title="Our Factories" alt="Our Factories" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/fashion-hang.jpg 570w, https://themify.me/demo/themes/shoppe-men/files/2018/08/fashion-hang-300x145.jpg 300w" sizes="(max-width: 570px) 100vw, 570px" /> </a> <h3> <a href="https://themify.me/" > Our Factories </a> </h3> 
 <a href="https://themify.me/" >Show All</a> 
<h3>Gallery<br/></h3>
 <ul data-id="slider-0-" data-visible="5" data-mob-visible="2" data-scroll="1" data-auto-scroll="off" data-speed="1" data-wrap="yes" data-arrow="yes" data-pagination="yes" data-effect="scroll" data-height="variable" data-pause-on-hover="resume" > 
 <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-683x1024-205x205.jpg" width="205" height="205" alt="men-model-with-black-shirt" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-683x1024-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-black-shirt-100x100.jpg 100w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-1024x1024-205x205.jpg" width="205" height="205" alt="men-model-with-ipad" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-1024x1024-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-1024x1024-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-768x769.jpg 768w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-1024x1024.jpg 1024w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-600x600.jpg 600w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad-100x100.jpg 100w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-ipad.jpg 1440w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-791x1024-205x205.jpg" width="205" height="205" alt="men-model-with-red-background" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-791x1024-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-red-background-100x100.jpg 100w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-760x1024-205x205.jpg" width="205" height="205" alt="men-model-with-casual-outfit" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-760x1024-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-casual-outfit-100x100.jpg 100w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-683x1024-205x205.jpg" width="205" height="205" alt="men-model-with-long-sleeves" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-683x1024-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-sleeves-100x100.jpg 100w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair.jpg" alt="" data-rel="slider-0-"> <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-1024x683-205x205.jpg" width="205" height="205" alt="men-model-in-chair" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-1024x683-205x205.jpg 205w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-150x150.jpg 150w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-300x300.jpg 300w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-chair-100x100.jpg 100w" sizes="(max-width: 205px) 100vw, 205px" /> </a> </li> </ul> 
 <a href="https://themify.me/" >Show All</a> 
<h3>Shop<br/></h3>
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-suit-380x364.jpg" width="380" height="364" title="Suit" alt="Suit" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-suit.jpg 380w, https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-suit-300x287.jpg 300w" sizes="(max-width: 380px) 100vw, 380px" /> <h3> Suit </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-outwear-380x364.jpg" width="380" height="364" title="Outwear" alt="Outwear" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-outwear.jpg 380w, https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-outwear-300x287.jpg 300w" sizes="(max-width: 380px) 100vw, 380px" /> <h3> Outwear </h3> 
 <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-shirts-380x364.jpg" width="380" height="364" title="Shirts" alt="Shirts" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-shirts.jpg 380w, https://themify.me/demo/themes/shoppe-men/files/2018/08/shop-shirts-300x287.jpg 300w" sizes="(max-width: 380px) 100vw, 380px" /> <h3> Shirts </h3> 
 <a href="https://themify.me/demo/themes/shoppe-men/shop/" >Show All</a> 
<h3>Style Guide<br/></h3>
 <a href="https://themify.me/demo/themes/shoppe-men/shop/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/casual-look-285x380.jpg" width="285" height="380" title="Casual Look" alt="Casual Look" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/casual-look.jpg 285w, https://themify.me/demo/themes/shoppe-men/files/2018/08/casual-look-225x300.jpg 225w" sizes="(max-width: 285px) 100vw, 285px" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-men/shop/" > Casual Look </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-men/shop/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-suit-285x380.jpg" width="285" height="380" title="Men&#039;s Suit" alt="Men&#039;s Suit" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/men-suit.jpg 285w, https://themify.me/demo/themes/shoppe-men/files/2018/08/men-suit-225x300.jpg 225w" sizes="(max-width: 285px) 100vw, 285px" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-men/shop/" > Men\'s Suit </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-men/shop/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/tuxedo-suit-285x380.jpg" width="285" height="380" title="Tuxedo" alt="Tuxedo" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/tuxedo-suit.jpg 285w, https://themify.me/demo/themes/shoppe-men/files/2018/08/tuxedo-suit-225x300.jpg 225w" sizes="(max-width: 285px) 100vw, 285px" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-men/shop/" > Tuxedo </a> </h3> 
 <a href="https://themify.me/demo/themes/shoppe-men/shop/" > <img src="https://themify.me/demo/themes/shoppe-men/files/2018/08/stylish-suit-285x380.jpg" width="285" height="380" title="Stylish Suit" alt="Stylish Suit" srcset="https://themify.me/demo/themes/shoppe-men/files/2018/08/stylish-suit.jpg 285w, https://themify.me/demo/themes/shoppe-men/files/2018/08/stylish-suit-225x300.jpg 225w" sizes="(max-width: 285px) 100vw, 285px" /> </a> <h3> <a href="https://themify.me/demo/themes/shoppe-men/shop/" > Stylish Suit </a> </h3><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2018-09-23 07:09:29',
  'post_modified_gmt' => '2018-09-23 07:09:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?page_id=7',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'header_wrap' => 'transparent',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"b288c58\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b28c665\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"7b280fd\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"background_color_icon\\":\\"#ffffff\\",\\"background_color_icon_hover\\":\\"#c0a477\\",\\"font_color_icon\\":\\"#000000\\",\\"font_color_icon_hover\\":\\"#ffffff\\",\\"f_s_i\\":\\"67\\",\\"icon_size\\":\\"normal\\",\\"icon_style\\":\\"circle\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-control-play\\",\\"link\\":\\"https:\\\\/\\\\/www.youtube.com\\\\/watch?v=DaSkMWVlFUU\\",\\"link_options\\":\\"lightbox\\",\\"lightbox_width_unit\\":\\"%\\",\\"lightbox_height_unit\\":\\"%\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"f_s_i\\":\\"39\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/shoppe-men-header.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"left-top\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"row_height\\":\\"fullheight\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-top\\",\\"background_color\\":\\"#f2f2f2\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"81f5297\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"81f5297\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"62077ec\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"b0ef700\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"New Arrivals\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\",\\"breakpoint_tablet_landscape\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"976112b\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_p_ctr_apply_all\\":\\"1\\",\\"checkbox_m_p_ctr_apply_all\\":\\"1\\",\\"b_p_ctr-type\\":\\"top\\",\\"checkbox_p_p_ct_apply_all\\":\\"1\\",\\"checkbox_m_p_ct_apply_all\\":\\"1\\",\\"b_p_ct-type\\":\\"top\\",\\"checkbox_p_p_t_apply_all\\":\\"1\\",\\"checkbox_m_p_t_apply_all\\":\\"1\\",\\"b_p_t-type\\":\\"top\\",\\"checkbox_p_p_p_apply_all\\":\\"1\\",\\"checkbox_m_p_p_apply_all\\":\\"1\\",\\"b_p_p-type\\":\\"top\\",\\"checkbox_p_p_b_apply_all\\":\\"1\\",\\"checkbox_m_p_b_apply_all\\":\\"1\\",\\"b_p_b-type\\":\\"top\\",\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_outofstock_products\\":\\"no\\",\\"post_per_page_products\\":\\"4\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"img_width_products\\":\\"285\\",\\"img_height_products\\":\\"182\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"721ef31\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#656262\\",\\"link_color\\":\\"#ffffff\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"f6f549b\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"8b3a906\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"41ceaf9\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Tips and News\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"post\\",\\"element_id\\":\\"151f9b4\\",\\"mod_settings\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"general_margin_bottom\\":\\"30\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\",\\"layout_post\\":\\"grid2-thumb\\",\\"post_type_post\\":\\"post\\",\\"type_query_post\\":\\"category\\",\\"category_post\\":\\"0|multiple\\",\\"post_tag_post\\":\\"0|multiple\\",\\"product_cat_post\\":\\"0|multiple\\",\\"product_tag_post\\":\\"0|multiple\\",\\"product_shipping_class_post\\":\\"0|multiple\\",\\"post_per_page_post\\":\\"4\\",\\"order_post\\":\\"desc\\",\\"orderby_post\\":\\"date\\",\\"display_post\\":\\"excerpt\\",\\"breakpoint_tablet_landscape\\":{\\"checkbox_general_padding_apply_all\\":\\"1\\",\\"general_border-type\\":\\"top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_t_apply_all\\":\\"1\\",\\"checkbox_m_t_apply_all\\":\\"1\\",\\"b_t-type\\":\\"top\\",\\"checkbox_p_d_apply_all\\":\\"1\\",\\"checkbox_m_d_apply_all\\":\\"1\\",\\"b_d-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"checkbox_c_m_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"checkbox_p_f_i_apply_all\\":\\"1\\",\\"checkbox_m_f_i_apply_all\\":\\"1\\",\\"b_f_i-type\\":\\"top\\"},\\"img_width_post\\":\\"300\\",\\"img_height_post\\":\\"360\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"6eebc17\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#656262\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Show All\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/blog\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"34293a7\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"1e746a7\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"e95dab8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Our Process\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"6252117\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"1f26d14\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"f9efa77\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/tailor.jpg\\",\\"width_image\\":\\"570\\",\\"title_image\\":\\"How it Works\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"c025525\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"75f6eea\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"font_color_caption\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-card-layout\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/fashion-hang.jpg\\",\\"width_image\\":\\"570\\",\\"title_image\\":\\"Our Factories\\",\\"link_image\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"50\\",\\"border-type\\":\\"top\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"7274d58\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#656262\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Show All\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"border_top_color\\":\\"#dddddd\\",\\"border_top_width\\":\\"1\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"2d62730\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"057fd54\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"2db8b25\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"50ba9f0\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color\\":\\"#ffffff\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Gallery\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"mod_name\\":\\"slider\\",\\"element_id\\":\\"d5a46ec\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_container_apply_all\\":\\"1\\",\\"checkbox_m_container_apply_all\\":\\"1\\",\\"b_container-type\\":\\"top\\",\\"layout_display_slider\\":\\"image\\",\\"post_type\\":\\"post\\",\\"taxonomy\\":\\"category\\",\\"blog_category_slider\\":\\"0|multiple\\",\\"posts_per_page_slider\\":\\"4\\",\\"order_slider\\":\\"desc\\",\\"orderby_slider\\":\\"date\\",\\"display_slider\\":\\"none\\",\\"img_content_slider\\":[{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-black-shirt.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-black-shirt.jpg\\",\\"img_link_params\\":\\"lightbox\\"},{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-ipad.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-ipad.jpg\\",\\"img_link_params\\":\\"lightbox\\"},{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-red-background.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-red-background.jpg\\",\\"img_link_params\\":\\"lightbox\\"},{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-casual-outfit.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-casual-outfit.jpg\\",\\"img_link_params\\":\\"lightbox\\"},{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-long-sleeves.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-with-long-sleeves.jpg\\",\\"img_link_params\\":\\"lightbox\\"},{\\"img_url_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-in-chair.jpg\\",\\"img_link_slider\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-model-in-chair.jpg\\",\\"img_link_params\\":\\"lightbox\\"}],\\"layout_slider\\":\\"slider-default\\",\\"img_w_slider\\":\\"205\\",\\"img_h_slider\\":\\"205\\",\\"visible_opt_slider\\":\\"5\\",\\"mob_visible_opt_slider\\":\\"2\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_arrow_buttons_vertical\\":\\"vertical\\",\\"height_slider\\":\\"variable\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"b3d625e\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#c0a477\\",\\"link_color\\":\\"#000000\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Show All\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}]}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#8b8a8a\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_layout\\":\\"zig-zag\\",\\"top-frame_color\\":\\"#ffffff\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height\\":\\"50\\",\\"top-frame_repeat\\":\\"2\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_layout\\":\\"zig-zag\\",\\"bottom-frame_color\\":\\"#ffffff\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height\\":\\"50\\",\\"bottom-frame_repeat\\":\\"2\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"breakpoint_tablet_landscape\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_layout\\":\\"zig-zag\\",\\"top-frame_color\\":\\"#ffffff\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height\\":\\"50\\",\\"top-frame_repeat\\":\\"2\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_layout\\":\\"zig-zag\\",\\"bottom-frame_color\\":\\"#ffffff\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height\\":\\"50\\",\\"bottom-frame_repeat\\":\\"2\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"},\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"5e96a6a\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"3af6b2c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"56a3595\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Shop\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"622e0f8\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"70688b2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"c62be88\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"_0.50\\",\\"b_c_c_h\\":\\"#c0a477_0.50\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/shop-suit.jpg\\",\\"width_image\\":\\"380\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"364\\",\\"title_image\\":\\"Suit\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"d135c4e\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ba66bd6\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"_0.50\\",\\"b_c_c_h\\":\\"#c0a477_0.50\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/shop-outwear.jpg\\",\\"width_image\\":\\"380\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"364\\",\\"title_image\\":\\"Outwear\\",\\"param_image\\":\\"regular\\"}}]},{\\"element_id\\":\\"562732e\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"b9602a3\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c\\":\\"_0.50\\",\\"b_c_c_h\\":\\"#c0a477_0.50\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-full-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/shop-shirts.jpg\\",\\"width_image\\":\\"380\\",\\"auto_fullwidth\\":\\"1\\",\\"height_image\\":\\"364\\",\\"title_image\\":\\"Shirts\\",\\"param_image\\":\\"regular\\"}}]}],\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"6e2ade1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"button_background_color\\":\\"#656262\\",\\"link_color\\":\\"#ffffff\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"xlarge\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Show All\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/shop\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"fdbc513\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"ebf136b\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"fancy-heading\\",\\"element_id\\":\\"1272576\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"d_border-type\\":\\"top\\",\\"heading\\":\\"Style Guide\\",\\"heading_tag\\":\\"h3\\",\\"text_alignment\\":\\"themify-text-center\\"}},{\\"element_id\\":\\"4915663\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"6e7c907\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"e5030e7\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e_0.80\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/casual-look.jpg\\",\\"width_image\\":\\"285\\",\\"height_image\\":\\"380\\",\\"title_image\\":\\"Casual Look\\",\\"link_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/shop\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"15\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"17abcf3\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"193dbe5\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e_0.80\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/men-suit.jpg\\",\\"width_image\\":\\"285\\",\\"height_image\\":\\"380\\",\\"title_image\\":\\"Men\\\\\\\\\\\'s Suit\\",\\"link_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/shop\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_tablet\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"15\\",\\"margin_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_c_p_apply_all\\":\\"1\\"}}}]},{\\"element_id\\":\\"aebce4e\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"73bbb18\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e_0.80\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/tuxedo-suit.jpg\\",\\"width_image\\":\\"285\\",\\"height_image\\":\\"380\\",\\"title_image\\":\\"Tuxedo\\",\\"link_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/shop\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"b77405d\\",\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"a6b922c\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"text_align\\":\\"center\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"b_c_c_h\\":\\"#23282e_0.80\\",\\"f_c_c_h\\":\\"#ffffff\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-overlay\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/files\\\\/2018\\\\/08\\\\/stylish-suit.jpg\\",\\"width_image\\":\\"285\\",\\"height_image\\":\\"380\\",\\"title_image\\":\\"Stylish Suit\\",\\"link_image\\":\\"https://themify.me/demo/themes/shoppe-men\\\\/shop\\\\/\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"b288c58\\",\\"unstick_when_el_mod_id\\":\\"7b280fd\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fbfbfb\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"top-frame_width_unit\\":\\"%\\",\\"top-frame_height_unit\\":\\"%\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"bottom-frame_width_unit\\":\\"%\\",\\"bottom-frame_height_unit\\":\\"%\\",\\"left-frame_type\\":\\"left-presets\\",\\"left-frame_width_unit\\":\\"%\\",\\"left-frame_height_unit\\":\\"%\\",\\"right-frame_type\\":\\"right-presets\\",\\"right-frame_width_unit\\":\\"%\\",\\"right-frame_height_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"4657060\\",\\"row_order\\":\\"7\\",\\"cols\\":[{\\"element_id\\":\\"2c7fbf8\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 26,
  'post_date' => '2018-08-23 02:29:42',
  'post_date_gmt' => '2018-08-23 02:29:42',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2018-08-23 02:29:42',
  'post_modified_gmt' => '2018-08-23 02:29:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 23,
  'post_date' => '2018-08-23 02:29:42',
  'post_date_gmt' => '2018-08-23 02:29:42',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2018-09-02 07:11:30',
  'post_modified_gmt' => '2018-09-02 07:11:30',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"qoc2000\\"}],\\"element_id\\":\\"mbgy209\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 264,
  'post_date' => '2018-09-11 06:06:23',
  'post_date_gmt' => '2018-09-11 06:06:23',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Wishlist',
  'post_excerpt' => '',
  'post_name' => 'wishlist',
  'post_modified' => '2019-05-09 01:40:04',
  'post_modified_gmt' => '2019-05-09 01:40:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?page_id=264',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"gztc299\\"}],\\"element_id\\":\\"udwt079\\"}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 272,
  'post_date' => '2018-09-11 07:01:20',
  'post_date_gmt' => '2018-09-11 07:01:20',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

',
  'post_title' => 'Men\'s Grey Suit',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'mens-grey-suit',
  'post_modified' => '2018-09-11 07:07:42',
  'post_modified_gmt' => '2018-09-11 07:07:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=272',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536649552:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"j6nz120\\"}],\\"element_id\\":\\"v8k7010\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '274',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-grey-suit-with-tie.jpg',
    '_regular_price' => '156',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '156',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-grey-suit-with-tie.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 275,
  'post_date' => '2018-09-10 07:15:30',
  'post_date_gmt' => '2018-09-10 07:15:30',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Men\'s Winter Scarf',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'mens-winter-scarf',
  'post_modified' => '2018-09-11 16:05:24',
  'post_modified_gmt' => '2018-09-11 16:05:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=275',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536682036:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"wa2z603\\"}],\\"element_id\\":\\"4y3g066\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '276',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-scraf.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '80',
    '_sale_price' => '65',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '65',
    '_yoast_wpseo_primary_product_cat' => '26',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_color' => 
      array (
        'name' => 'pa_color',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
    'pa_color' => 'black, brown, dark-blue, dark-green, red',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-scraf.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 277,
  'post_date' => '2018-09-09 07:24:54',
  'post_date_gmt' => '2018-09-09 07:24:54',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Men\'s Brown Hoodie Jacket',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.',
  'post_name' => 'mens-brown-hoodie-jacket',
  'post_modified' => '2018-09-11 07:25:10',
  'post_modified_gmt' => '2018-09-11 07:25:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=277',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '1',
    '_wc_rating_count' => 
    array (
      5 => 1,
    ),
    '_wc_average_rating' => '5.00',
    '_edit_lock' => '1536650892:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"desh909\\"}],\\"element_id\\":\\"24qe885\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '279',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-jacket.jpg',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '125',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_wp_old_date' => '2018-09-11',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'rated-5',
    'product_cat' => 'casual, sporty',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 280,
  'post_date' => '2018-09-07 07:30:35',
  'post_date_gmt' => '2018-09-07 07:30:35',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Men\'s Light Brown Suit',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet',
  'post_name' => 'mens-light-brown-suit',
  'post_modified' => '2018-09-11 07:32:05',
  'post_modified_gmt' => '2018-09-11 07:32:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=280',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536651145:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"1lbl007\\"}],\\"element_id\\":\\"31tu056\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '281',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-light-brown-suit.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '250',
    '_sale_price' => '225',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '225',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-light-brown-suit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 282,
  'post_date' => '2018-09-06 07:32:24',
  'post_date_gmt' => '2018-09-06 07:32:24',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Men\'s Outdoor Hat',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'mens-outdoor-hat',
  'post_modified' => '2018-09-11 16:01:18',
  'post_modified_gmt' => '2018-09-11 16:01:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=282',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681577:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"6ey9365\\"}],\\"element_id\\":\\"rw1a644\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '283',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-hat.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '80',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '80',
    '_yoast_wpseo_primary_product_cat' => '26',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_color' => 
      array (
        'name' => 'pa_color',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
    'pa_color' => 'black, brown, dark-green',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-hat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 284,
  'post_date' => '2018-09-04 07:34:49',
  'post_date_gmt' => '2018-09-04 07:34:49',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit.',
  'post_title' => 'Men\'s Dark Grey Suit',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.

',
  'post_name' => 'mens-dark-grey-suit',
  'post_modified' => '2018-09-11 07:36:45',
  'post_modified_gmt' => '2018-09-11 07:36:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=284',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536651300:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"enyv319\\"}],\\"element_id\\":\\"8ram170\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '285',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-suit-dark-grey.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '200',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '200',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-suit-dark-grey.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 286,
  'post_date' => '2018-09-03 07:40:06',
  'post_date_gmt' => '2018-09-03 07:40:06',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Dark Blue Office Suit',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.',
  'post_name' => 'dark-blue-office-suit',
  'post_modified' => '2018-09-21 20:54:46',
  'post_modified_gmt' => '2018-09-21 20:54:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=286',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1537563236:2',
    '_edit_last' => '2',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"b28fddf\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0773777\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '287',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-working-outfit.jpg',
    '_regular_price' => '450',
    '_sale_price' => '400',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '400',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
    '_wp_old_date' => '2018-09-11',
    '_wp_old_slug' => 'mens-dark-blue-office-suit-set',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-working-outfit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 290,
  'post_date' => '2018-09-02 07:51:03',
  'post_date_gmt' => '2018-09-02 07:51:03',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Men\'s Polka Dot Shirt',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.',
  'post_name' => 'mens-polka-dot-shirt',
  'post_modified' => '2018-09-21 20:53:52',
  'post_modified_gmt' => '2018-09-21 20:53:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=290',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1537563091:2',
    '_edit_last' => '2',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"88595c2\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c2cbf87\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '292',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-polkadot.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '60',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '60',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_wp_old_slug' => 'mens-polka-dot-casual-t-shirt',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-polkadot.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 293,
  'post_date' => '2018-09-01 08:02:04',
  'post_date_gmt' => '2018-09-01 08:02:04',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Men\'s Black Trench Coat',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'mens-black-trench-coat',
  'post_modified' => '2018-09-11 08:05:06',
  'post_modified_gmt' => '2018-09-11 08:05:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=293',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536653076:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"712k251\\"}],\\"element_id\\":\\"3c1s245\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '294',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-black-trench-coat.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '325',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '325',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-black-trench-coat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 295,
  'post_date' => '2018-08-29 08:06:59',
  'post_date_gmt' => '2018-08-29 08:06:59',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Men\'s Black Hoodie',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt.',
  'post_name' => 'mens-black-hoodie',
  'post_modified' => '2018-09-11 08:08:14',
  'post_modified_gmt' => '2018-09-11 08:08:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=295',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536653191:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"b8tx950\\"}],\\"element_id\\":\\"i7sa306\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '296',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-black-hoodie.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '125',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual, sporty',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-black-hoodie.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 298,
  'post_date' => '2018-08-27 15:04:49',
  'post_date_gmt' => '2018-08-27 15:04:49',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Men\'s Fedora Hat',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'mens-fedora-hat',
  'post_modified' => '2018-09-11 15:06:10',
  'post_modified_gmt' => '2018-09-11 15:06:10',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=298',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536678255:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"m6qk332\\"}],\\"element_id\\":\\"jnvb300\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '299',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-fedora-hat.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '125',
    '_yoast_wpseo_primary_product_cat' => '26',
    '_yoast_wpseo_content_score' => '30',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-fedora-hat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 300,
  'post_date' => '2018-08-26 15:06:38',
  'post_date_gmt' => '2018-08-26 15:06:38',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Men\'s Winter Sweater',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.',
  'post_name' => 'mens-winter-sweater',
  'post_modified' => '2018-09-11 15:58:05',
  'post_modified_gmt' => '2018-09-11 15:58:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=300',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681397:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"j9jp583\\"}],\\"element_id\\":\\"m3wh030\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '301',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-sweater.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '122',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '122',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_size' => 
      array (
        'name' => 'pa_size',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
    'pa_size' => 'l, xl, xxl',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/men-sweater.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 302,
  'post_date' => '2018-08-25 15:08:53',
  'post_date_gmt' => '2018-08-25 15:08:53',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Men\'s Sunglasses',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt.',
  'post_name' => 'mens-sunglasses',
  'post_modified' => '2018-09-11 15:24:04',
  'post_modified_gmt' => '2018-09-11 15:24:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=302',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536679336:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"hbrt203\\"}],\\"element_id\\":\\"2gpg820\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '303',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-sunglasses.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '156',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '156',
    '_yoast_wpseo_primary_product_cat' => '26',
    '_yoast_wpseo_content_score' => '30',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-sunglasses.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 304,
  'post_date' => '2018-08-24 15:12:39',
  'post_date_gmt' => '2018-08-24 15:12:39',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_title' => 'Men\'s Casual Plaid Shirt',
  'post_excerpt' => 'Aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam.',
  'post_name' => 'mens-casual-plaid-shirt',
  'post_modified' => '2018-09-11 16:02:40',
  'post_modified_gmt' => '2018-09-11 16:02:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=304',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681701:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"x9oy560\\"}],\\"element_id\\":\\"em8b885\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '305',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-shirt.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '98',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '98',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_color' => 
      array (
        'name' => 'pa_color',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
      'pa_size' => 
      array (
        'name' => 'pa_size',
        'value' => '',
        'position' => 2,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
    'pa_color' => 'black, brown, red',
    'pa_size' => 'l, xl, xxl',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/mens-shirt.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 308,
  'post_date' => '2018-08-23 15:19:38',
  'post_date_gmt' => '2018-08-23 15:19:38',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Casual Blue Shirt',
  'post_excerpt' => 'Aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_name' => 'casual-blue-shirt',
  'post_modified' => '2018-09-11 16:03:14',
  'post_modified_gmt' => '2018-09-11 16:03:14',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=308',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681699:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"m1uv300\\"}],\\"element_id\\":\\"d9j3303\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '309',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/blue-shirt.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '122',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '122',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_size' => 
      array (
        'name' => 'pa_size',
        'value' => '',
        'position' => 0,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
    'pa_size' => 'l, xl, xxl',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/blue-shirt.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 40,
  'post_date' => '2018-08-23 03:04:54',
  'post_date_gmt' => '2018-08-23 03:04:54',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.
',
  'post_title' => 'Men\'s Blue Jean',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.
',
  'post_name' => 'mens-blue-jean',
  'post_modified' => '2018-09-11 07:07:19',
  'post_modified_gmt' => '2018-09-11 07:07:19',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=40',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536649551:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"e4bu008\\"}],\\"element_id\\":\\"qexp505\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '41',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/model-with-jeans.jpg',
    '_regular_price' => '156',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_attributes' => 
    array (
      'color' => 
      array (
        'name' => 'Color',
        'value' => 'Blue',
        'position' => 0,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 0,
      ),
    ),
    '_product_version' => '3.4.5',
    '_price' => '156',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/model-with-jeans.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 306,
  'post_date' => '2018-08-22 15:16:24',
  'post_date_gmt' => '2018-08-22 15:16:24',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Urban Style Jacket',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'urban-style-jacket',
  'post_modified' => '2018-09-11 16:00:31',
  'post_modified_gmt' => '2018-09-11 16:00:31',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=306',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681703:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"2ilk602\\"}],\\"element_id\\":\\"8fuy900\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '307',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/urban-style-jacket.jpg',
    '_wp_old_date' => '2018-09-11',
    '_regular_price' => '225',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '225',
    '_yoast_wpseo_primary_product_cat' => '17',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'pa_size' => 
      array (
        'name' => 'pa_size',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual',
    'pa_size' => 'l, xl, xxl',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/09/urban-style-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 31,
  'post_date' => '2018-08-22 02:53:15',
  'post_date_gmt' => '2018-08-22 02:53:15',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Men\'s Brown Long Coat',
  'post_excerpt' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt.',
  'post_name' => 'mens-brown-long-coat',
  'post_modified' => '2018-09-11 16:02:58',
  'post_modified_gmt' => '2018-09-11 16:02:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=31',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536681698:172',
    '_edit_last' => '172',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_attributes' => 
    array (
      'pa_size' => 
      array (
        'name' => 'pa_size',
        'value' => '',
        'position' => 1,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 1,
      ),
    ),
    '_product_version' => '3.4.5',
    '_price' => '250',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"cr1y200\\"}],\\"element_id\\":\\"tjgl020\\"}]',
    'layout' => 'sidebar-none',
    'content_width' => 'default_width',
    '_thumbnail_id' => '37',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-coat.jpg',
    '_yoast_wpseo_content_score' => '30',
    '_wp_old_date' => '2018-08-23',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'casual, office',
    'pa_size' => 'l, xl, xxl',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-with-long-coat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 39,
  'post_date' => '2018-08-21 02:59:08',
  'post_date_gmt' => '2018-08-21 02:59:08',
  'post_content' => ' Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Men\'s White Shirt',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.
',
  'post_name' => 'mens-white-shirt',
  'post_modified' => '2018-09-11 07:07:51',
  'post_modified_gmt' => '2018-09-11 07:07:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=39',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536649556:172',
    '_edit_last' => '172',
    '_regular_price' => '122',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_attributes' => 
    array (
      'color' => 
      array (
        'name' => 'Color',
        'value' => 'White',
        'position' => 0,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 0,
      ),
    ),
    '_product_version' => '3.4.5',
    '_price' => '122',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"5jym011\\"}],\\"element_id\\":\\"b6kn300\\"}]',
    'content_width' => 'default_width',
    '_thumbnail_id' => '36',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-office.jpg',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
    '_wp_old_date' => '2018-08-23',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-model-in-office.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 21,
  'post_date' => '2018-08-20 02:30:49',
  'post_date_gmt' => '2018-08-20 02:30:49',
  'post_content' => 'Voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Black Office Suit',
  'post_excerpt' => 'Numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.
',
  'post_name' => 'mens-leather-bag',
  'post_modified' => '2018-09-11 07:07:08',
  'post_modified_gmt' => '2018-09-11 07:07:08',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?post_type=product&#038;p=21',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1536649540:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"cols\\":[{\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"element_id\\":\\"gpke020\\"}],\\"element_id\\":\\"734h057\\"}]',
    'layout' => 'sidebar-none',
    'content_width' => 'default_width',
    '_thumbnail_id' => '34',
    'post_image' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-wearing-office-outfit.jpg',
    '_regular_price' => '225',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.4.5',
    '_price' => '225',
    '_yoast_wpseo_primary_product_cat' => '16',
    '_yoast_wpseo_content_score' => '30',
    '_product_attributes' => 
    array (
      'color' => 
      array (
        'name' => 'Color',
        'value' => 'Black, Dark Brown, Light Brown',
        'position' => 0,
        'is_visible' => 1,
        'is_variation' => 0,
        'is_taxonomy' => 0,
      ),
    ),
    '_wp_old_date' => '2018-08-23',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-men/files/2018/08/men-wearing-office-outfit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 113,
  'post_date' => '2018-08-23 07:04:34',
  'post_date_gmt' => '2018-08-23 07:04:34',
  'post_content' => '',
  'post_title' => 'About Us',
  'post_excerpt' => '',
  'post_name' => 'about-us',
  'post_modified' => '2018-08-23 07:06:07',
  'post_modified_gmt' => '2018-08-23 07:06:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=113',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '113',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 114,
  'post_date' => '2018-08-23 07:06:07',
  'post_date_gmt' => '2018-08-23 07:06:07',
  'post_content' => '',
  'post_title' => 'History',
  'post_excerpt' => '',
  'post_name' => 'history',
  'post_modified' => '2018-08-23 07:06:07',
  'post_modified_gmt' => '2018-08-23 07:06:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=114',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '114',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 115,
  'post_date' => '2018-08-23 07:06:07',
  'post_date_gmt' => '2018-08-23 07:06:07',
  'post_content' => '',
  'post_title' => 'Careers',
  'post_excerpt' => '',
  'post_name' => 'careers',
  'post_modified' => '2018-08-23 07:06:07',
  'post_modified_gmt' => '2018-08-23 07:06:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=115',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '115',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 116,
  'post_date' => '2018-08-23 07:06:07',
  'post_date_gmt' => '2018-08-23 07:06:07',
  'post_content' => '',
  'post_title' => 'Track Order',
  'post_excerpt' => '',
  'post_name' => 'track-order',
  'post_modified' => '2018-08-23 07:06:07',
  'post_modified_gmt' => '2018-08-23 07:06:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=116',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '116',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 117,
  'post_date' => '2018-08-23 07:06:07',
  'post_date_gmt' => '2018-08-23 07:06:07',
  'post_content' => '',
  'post_title' => 'Contact us',
  'post_excerpt' => '',
  'post_name' => 'contact-us',
  'post_modified' => '2018-08-23 07:06:07',
  'post_modified_gmt' => '2018-08-23 07:06:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=117',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '117',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 118,
  'post_date' => '2018-08-23 07:08:05',
  'post_date_gmt' => '2018-08-23 07:08:05',
  'post_content' => '',
  'post_title' => 'Delivery',
  'post_excerpt' => '',
  'post_name' => 'delivery',
  'post_modified' => '2018-08-23 07:08:05',
  'post_modified_gmt' => '2018-08-23 07:08:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=118',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '118',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'customer-support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 119,
  'post_date' => '2018-08-23 07:08:05',
  'post_date_gmt' => '2018-08-23 07:08:05',
  'post_content' => '',
  'post_title' => 'Payment',
  'post_excerpt' => '',
  'post_name' => 'payment',
  'post_modified' => '2018-08-23 07:08:05',
  'post_modified_gmt' => '2018-08-23 07:08:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=119',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '119',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'customer-support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 120,
  'post_date' => '2018-08-23 07:08:06',
  'post_date_gmt' => '2018-08-23 07:08:06',
  'post_content' => '',
  'post_title' => 'FAQ',
  'post_excerpt' => '',
  'post_name' => 'faq',
  'post_modified' => '2018-08-23 07:08:06',
  'post_modified_gmt' => '2018-08-23 07:08:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=120',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '120',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'customer-support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 121,
  'post_date' => '2018-08-23 07:08:06',
  'post_date_gmt' => '2018-08-23 07:08:06',
  'post_content' => '',
  'post_title' => 'Shipping info',
  'post_excerpt' => '',
  'post_name' => 'shipping-info',
  'post_modified' => '2018-08-23 07:08:06',
  'post_modified_gmt' => '2018-08-23 07:08:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=121',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '121',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'customer-support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 100,
  'post_date' => '2018-08-23 06:18:28',
  'post_date_gmt' => '2018-08-23 06:18:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '100',
  'post_modified' => '2018-09-01 16:31:54',
  'post_modified_gmt' => '2018-09-01 16:31:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=100',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '7',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 152,
  'post_date' => '2018-09-01 16:31:54',
  'post_date_gmt' => '2018-09-01 16:31:54',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '152',
  'post_modified' => '2018-09-01 16:31:54',
  'post_modified_gmt' => '2018-09-01 16:31:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=152',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '146',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 99,
  'post_date' => '2018-08-23 06:18:28',
  'post_date_gmt' => '2018-08-23 06:18:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '99',
  'post_modified' => '2018-09-01 16:31:54',
  'post_modified_gmt' => '2018-09-01 16:31:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=99',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '23',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 109,
  'post_date' => '2018-08-23 06:19:33',
  'post_date_gmt' => '2018-08-23 06:19:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '109',
  'post_modified' => '2018-09-01 16:31:54',
  'post_modified_gmt' => '2018-09-01 16:31:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=109',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '101',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 108,
  'post_date' => '2018-08-23 06:19:33',
  'post_date_gmt' => '2018-08-23 06:19:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '108',
  'post_modified' => '2018-09-01 16:31:54',
  'post_modified_gmt' => '2018-09-01 16:31:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-men/?p=108',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '103',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_woocommerce_products" );
$widgets[1002] = array (
  'title' => 'Recent Products',
  'number' => 5,
  'show' => '',
  'orderby' => 'date',
  'order' => 'desc',
  'hide_free' => 0,
  'show_hidden' => 0,
);
update_option( "widget_woocommerce_products", $widgets );

$widgets = get_option( "widget_themify-twitter" );
$widgets[1003] = array (
  'title' => 'Latest Tweets',
  'username' => 'themify',
  'type' => '0',
  'timeline_height' => '400',
  'timeline_width' => '300',
  'show_count' => '3',
  'hide_timestamp' => NULL,
  'grid_embed_code' => '',
  'hide_footer' => NULL,
  'show_follow' => NULL,
  'follow_text' => '→ Follow me',
  'include_retweets' => NULL,
  'exclude_replies' => NULL,
);
update_option( "widget_themify-twitter", $widgets );

$widgets = get_option( "widget_custom_html" );
$widgets[1004] = array (
  'title' => '',
  'content' => '',
);
update_option( "widget_custom_html", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1005] = array (
  'title' => '',
  'text' => '[searchandfilter id="sidebar_filter"]',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_woocommerce_product_categories" );
$widgets[1006] = array (
  'title' => 'Catalog',
  'orderby' => 'name',
  'dropdown' => 0,
  'count' => 0,
  'hierarchical' => 1,
  'show_children_only' => 0,
  'hide_empty' => 0,
  'max_depth' => '',
);
update_option( "widget_woocommerce_product_categories", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1007] = array (
  'title' => 'About',
  'nav_menu' => themify_import_get_term_id_from_slug( "about" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1008] = array (
  'title' => 'Help',
  'nav_menu' => themify_import_get_term_id_from_slug( "customer-support" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1009] = array (
  'title' => 'Contacts',
  'text' => '<h3>+01 3391-002</h3>

32 Old Burlington St, London W1S 3AT, United Kingdom

<a href="mailto:example@email.com">support@shoppe-men.com</a>',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'woocommerce_products-1002',
    1 => 'themify-twitter-1003',
  ),
  'below-logo-widget' => 
  array (
    0 => 'custom_html-1004',
  ),
  'sidebar-shop' => 
  array (
    0 => 'text-1005',
  ),
  'footer-widget-1' => 
  array (
    0 => 'woocommerce_product_categories-1006',
  ),
  'footer-widget-2' => 
  array (
    0 => 'nav_menu-1007',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1008',
  ),
  'footer-widget-4' => 
  array (
    0 => 'text-1009',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:105:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:5:"grid3";s:27:"setting-post_content_layout";s:5:"boxed";s:20:"setting-post_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:4:"none";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:24:"setting-image_post_width";s:3:"270";s:25:"setting-image_post_height";s:1:"0";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:31:"setting-image_post_single_width";s:3:"840";s:32:"setting-image_post_single_height";s:3:"400";s:28:"setting-search-result_layout";s:8:"sidebar1";s:33:"setting-search-result_post_layout";s:9:"list-post";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:16:"header-logo-left";s:21:"setting-footer_design";s:18:"footer-left-column";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:39:"settings-footer_banner_twitter_username";s:7:"Themify";s:24:"setting-footer_text_left";s:43:"2018 Men’s Fashion , All rights reserved.";s:25:"setting-footer_text_right";s:235:"<a href="https://www.facebook.com/themify"><i class="ti-facebook"></i></a>
<a href="https://twitter.com/themify"><i class="ti-twitter-alt"></i></a>
<a href="https://plus.google.com/109280316400365629341"><i class="ti-google"></i></a>";s:19:"setting-shop_layout";s:8:"sidebar1";s:27:"setting-shop_archive_layout";s:8:"sidebar1";s:23:"setting-products_layout";s:5:"grid3";s:27:"setting-product_post_gutter";s:6:"gutter";s:23:"setting-products_slider";s:6:"enable";s:46:"setting-default_product_index_image_post_width";s:3:"280";s:47:"setting-default_product_index_image_post_height";s:3:"300";s:29:"setting-single_product_layout";s:8:"sidebar1";s:47:"setting-default_product_single_image_post_width";s:3:"440";s:48:"setting-default_product_single_image_post_height";s:3:"500";s:28:"setting-product_gallery_type";s:4:"zoom";s:30:"setting-related_products_limit";s:1:"3";s:21:"setting-wishlist_page";s:3:"264";s:18:"setting-cart_style";s:8:"dropdown";s:25:"setting-cart_show_seconds";s:4:"1000";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:105:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:106:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:109:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:105:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:107:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:32:"setting-link_link_themify-link-6";s:28:"https://facebook.com/themify";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:35:"setting-link_ficolor_themify-link-6";s:7:"#ffffff";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:32:"setting-link_link_themify-link-5";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:35:"setting-link_ficolor_themify-link-5";s:7:"#ffffff";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:32:"setting-link_link_themify-link-7";s:45:"https://plus.google.com/109280316400365629341";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:35:"setting-link_ficolor_themify-link-7";s:7:"#ffffff";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-6":"themify-link-6","themify-link-5":"themify-link-5","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:94:"https://themify.me/demo/themes/shoppe-men/wp-content/themes/themify-shoppe/skins/men/style.css";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();