<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 21,
  'name' => 'Accessories',
  'slug' => 'accessories',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/accesories.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 25,
  'name' => 'Technology',
  'slug' => 'technology',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/drone-1.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 26,
  'name' => 'Watches',
  'slug' => 'watches',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 21,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 27,
  'name' => 'Furniture',
  'slug' => 'furniture',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/furniture.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 28,
  'name' => 'Jewellery',
  'slug' => 'jewellery',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 21,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 29,
  'name' => 'Smart Watch',
  'slug' => 'smart-watch',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 25,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 30,
  'name' => 'Computer',
  'slug' => 'computer',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 25,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 31,
  'name' => 'Mobile',
  'slug' => 'mobile',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 25,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 32,
  'name' => 'Office',
  'slug' => 'office',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
  'thumbnail' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/office.jpg',
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 33,
  'name' => 'Decor',
  'slug' => 'decor',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 32,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 34,
  'name' => 'Lighting',
  'slug' => 'lighting',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 32,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 15,
  'name' => 'Docks &amp; Cases',
  'slug' => 'docks-cases',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 32,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Vase',
  'slug' => 'vase',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 21,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 17,
  'name' => 'Storage',
  'slug' => 'storage',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 27,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 18,
  'name' => 'Chair',
  'slug' => 'chair',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 27,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 19,
  'name' => 'Lamp',
  'slug' => 'lamp',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 27,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 22,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 23,
  'name' => 'About',
  'slug' => 'about',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 24,
  'name' => 'Support',
  'slug' => 'support',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 35,
  'name' => 'Social',
  'slug' => 'social',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 36,
  'name' => 'Product Categories',
  'slug' => 'product-categories',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 212,
  'post_date' => '2018-11-27 04:45:48',
  'post_date_gmt' => '2018-11-27 04:45:48',
  'post_content' => '<!--themify_builder_static--><h1>About us</h1> 
 <h3>Our Mission</h3> <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.</p> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet.</p> <p> </p> <h3>Our vision</h3> <p>Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/about-image-450x600.jpg" width="450" alt="about image" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/about-image-450x600.jpg 450w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/about-image.jpg 492w" sizes="(max-width: 450px) 100vw, 450px" /> 
 <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut eni m ad minim venia.</p> 
 <h3>Our Story</h3> 
 <ul> <li id="timeline-0">
 2015 
 
 <h2></h2> <p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur</p> <p>[gallery size="full" ids="226,225,224"]</p> 
 </li>
 <li id="timeline-1">
 2017 
 
 <h2></h2> <p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.</p> 
 </li>
 <li id="timeline-2">
 2018 
 
 <h2></h2> <p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.</p> 
 </li>
 </ul> 
 <h3>Our team</h3> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/susie-smith-120x120.jpg" width="120" height="120" alt="susie smith" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/susie-smith-120x120.jpg 120w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/susie-smith-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/susie-smith-100x100.jpg 100w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/susie-smith.jpg 150w" sizes="(max-width: 120px) 100vw, 120px" /> 
 <h3>Susie Smith</h3> 
 <a href="https://instagram.com/themify"> </a> <a href="https://plus.google.com/109280316400365629341"> </a> <a href="https://www.linkedin.com/company/themify/"> </a> 
 <p>Duis aute irure dolor in in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur occaecat cupidatat non proident, in culpaqui officia deserunt anim id est laborum.</p> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/jean-lee-120x120.jpg" width="120" height="120" alt="jean lee" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/jean-lee-120x120.jpg 120w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/jean-lee-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/jean-lee-100x100.jpg 100w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/jean-lee.jpg 150w" sizes="(max-width: 120px) 100vw, 120px" /> 
 <h3>Jean Lee</h3> 
 <a href="https://instagram.com/themify"> </a> <a href="https://plus.google.com/109280316400365629341"> </a> <a href="https://www.linkedin.com/company/themify/"> </a> 
 <p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur omnis voluptas assumenda.</p> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/mark-johnson-120x120.jpg" width="120" height="120" alt="mark johnson" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/mark-johnson-120x120.jpg 120w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/mark-johnson-40x40.jpg 40w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/mark-johnson-100x100.jpg 100w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/mark-johnson.jpg 150w" sizes="(max-width: 120px) 100vw, 120px" /> 
 <h3>Mark Johnson</h3> 
 <a href="https://instagram.com/themify"> </a> <a href="https://plus.google.com/109280316400365629341"> </a> <a href="https://www.linkedin.com/company/themify/"> </a> 
 <p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. </p><!--/themify_builder_static-->',
  'post_title' => 'About Us',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2018-12-05 22:55:24',
  'post_modified_gmt' => '2018-12-05 22:55:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?page_id=212',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2f73454\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"f5e79f6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"555b6ae\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>About us<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"335c335\\",\\"unstick_when_el_mod_id\\":\\"2b52ccc\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"0bf69ba\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"0079d61\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a1496cb\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Our Mission<\\\\/h3>\\\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.<\\\\/p>\\\\n<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet.<\\\\/p>\\\\n<p> <\\\\/p>\\\\n<h3>Our vision<\\\\/h3>\\\\n<p>Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"4\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\"}},{\\"element_id\\":\\"3244dad\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"38b378f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/about-image-450x600.jpg\\",\\"width_image\\":\\"450\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"2\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"180dfa5\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"8ce652f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"bd1e798\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"df4f2e2\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_size\\":\\"15\\",\\"line_height\\":\\"2.3\\",\\"line_height_unit\\":\\"em\\",\\"text_transform\\":\\"uppercase\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut eni m ad minim venia.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#fcbb24_0.90\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-7\\",\\"margin_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"06071d7\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"6cbc66f\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"8d604da\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"5a4ce6a\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Our Story<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"timeline\\",\\"element_id\\":\\"c89f57a\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"c_b-type\\":\\"top\\",\\"template_timeline\\":\\"list\\",\\"source_timeline\\":\\"text\\",\\"category_post_timeline\\":\\"0|multiple\\",\\"post_per_page_post_timeline\\":\\"4\\",\\"order_post_timeline\\":\\"desc\\",\\"orderby_post_timeline\\":\\"date\\",\\"display_post_timeline\\":\\"excerpt\\",\\"hide_feat_img_post_timeline\\":\\"no\\",\\"text_source_timeline\\":[{\\"date_timeline\\":\\"2015\\",\\"content_timeline\\":\\"<p>Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur<\\\\/p>\\\\n<p>[gallery size=\\\\\\\\\\\\\\"full\\\\\\\\\\\\\\" ids=\\\\\\\\\\\\\\"226,225,224\\\\\\\\\\\\\\"]<\\\\/p>\\"},{\\"date_timeline\\":\\"2017\\",\\"content_timeline\\":\\"<p>Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur. Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.<\\\\/p>\\"},{\\"date_timeline\\":\\"2018\\",\\"content_timeline\\":\\"<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat.<\\\\/p>\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}]},{\\"element_id\\":\\"f3f948e\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"b758c0a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"8d76c94\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"67aadfc\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"cd81b78\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Our team<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffffff\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\"}},{\\"element_id\\":\\"23cd0f8\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"f196d6b\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"18a8038\\",\\"column_order\\":\\"3\\",\\"grid_class\\":\\"col4-1\\"}],\\"col_mobile\\":\\"column4-2\\"}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/our-team-bg.jpg\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"360\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"fullcover\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"200\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"font_color\\":\\"#000000\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"e00f823\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"d5e4584\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"3890c1e\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4b15c5e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4e43ec8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/susie-smith.jpg\\",\\"width_image\\":\\"120\\",\\"height_image\\":\\"120\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"5e1c845\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"258d0ce\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Susie Smith<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2c03478\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#b2b2b2\\",\\"font_color_icon_hover\\":\\"#fcc226\\",\\"icon_size\\":\\"small\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/instagram.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-google\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/plus.google.com\\\\/109280316400365629341\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_mobile\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"68714a1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Duis aute irure dolor in in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur occaecat cupidatat non proident, in culpaqui officia deserunt anim id est laborum.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"3\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\"}}},{\\"element_id\\":\\"8e569bb\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"a6191c9\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"82df5ce\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4e43ec8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/jean-lee.jpg\\",\\"width_image\\":\\"120\\",\\"height_image\\":\\"120\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"f32d8bc\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"258d0ce\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Jean Lee<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2c03478\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#b2b2b2\\",\\"font_color_icon_hover\\":\\"#fcc226\\",\\"icon_size\\":\\"small\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"link\\":\\"https:\\\\/\\\\/instagram.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\",\\"icon_color_bg\\":\\"\\"},{\\"icon\\":\\"ti-google\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/plus.google.com\\\\/109280316400365629341\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_mobile\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"68714a1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur omnis voluptas assumenda.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\"}},{\\"element_id\\":\\"d13f541\\",\\"column_order\\":\\"2\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"element_id\\":\\"3890c1e\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4b15c5e\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"4e43ec8\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/mark-johnson.jpg\\",\\"width_image\\":\\"120\\",\\"height_image\\":\\"120\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]},{\\"element_id\\":\\"5e1c845\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"258d0ce\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Mark Johnson<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"2c03478\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_icon\\":\\"#b2b2b2\\",\\"font_color_icon_hover\\":\\"#fcc226\\",\\"icon_size\\":\\"small\\",\\"icon_style\\":\\"none\\",\\"icon_position\\":\\"icon_position_left\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/instagram.com\\\\/themify\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-google\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/plus.google.com\\\\/109280316400365629341\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"gray\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\",\\"new_window\\":\\"\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"col_mobile\\":\\"column4-2\\",\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"68714a1\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<p>Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. <\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"0bf69ba\\",\\"unstick_when_el_mod_id\\":\\"a1496cb\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f0f0f0\\",\\"border_left_width\\":\\"1\\"}}],\\"gutter\\":\\"gutter-none\\"},{\\"element_id\\":\\"dde730f\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"c00055a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 5,
  'post_date' => '2018-11-21 06:27:45',
  'post_date_gmt' => '2018-11-21 06:27:45',
  'post_content' => '[woocommerce_cart]',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2018-11-26 01:19:05',
  'post_modified_gmt' => '2018-11-26 01:19:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f35daf5\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"3a6e488\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 6,
  'post_date' => '2018-11-21 06:27:45',
  'post_date_gmt' => '2018-11-21 06:27:45',
  'post_content' => '[woocommerce_checkout]',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2018-11-21 06:27:45',
  'post_modified_gmt' => '2018-11-21 06:27:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 244,
  'post_date' => '2018-11-27 07:21:04',
  'post_date_gmt' => '2018-11-27 07:21:04',
  'post_content' => '<!--themify_builder_static--><h1>Contact</h1>
<h4>Phone</h4> <p>(111) 123-145-786</p> <h4>Email </h4> <p>craft@email.com</p> <h4>Address</h4> <p>11730 Yonge St, Richmond Hill, Canada</p>
<h3></h3><iframe frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?q=1+Youge+Street%2C+Toronto%2C+ON&amp;t=m&amp;z=15&amp;output=embed&amp;iwloc=near"></iframe>
<h4>Working Hours</h4> <p>Monday : 09 - 20</p> <p>Tuesday  : 09 - 20</p> <p>Wednesday :  09 - 20</p> <p>Thursday : 09 - 20</p> <p>Friday : 09 - 20</p> <p>Saturday : 09 - 27</p> <p>Sunday  -</p>
<img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/contact-image-500x609.jpg" width="500" alt="contact image" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/contact-image.jpg 500w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/contact-image-493x600.jpg 493w" sizes="(max-width: 500px) 100vw, 500px" />
<form action="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Your Name </label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" /> <label for="contact-0--contact-email">Your Email </label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send Message </button> </form><!--/themify_builder_static-->',
  'post_title' => 'Contact Us',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-07-10 08:59:59',
  'post_modified_gmt' => '2019-07-10 08:59:59',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?page_id=244',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2f73454\\",\\"cols\\":[{\\"element_id\\":\\"f5e79f6\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"555b6ae\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\",\\"stick_at_position\\":\\"top\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"335c335\\",\\"cols\\":[{\\"element_id\\":\\"1ab0b11\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"2b52ccc\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_bottom\\":\\"40\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>Phone<\\\\/h4>\\\\n<p>(111) 123-145-786<\\\\/p>\\\\n<h4>Email <\\\\/h4>\\\\n<p>craft@email.com<\\\\/p>\\\\n<h4>Address<\\\\/h4>\\\\n<p>11730 Yonge St, Richmond Hill, Canada<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}},{\\"mod_name\\":\\"map\\",\\"element_id\\":\\"0f0ca99\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"map_display_type\\":\\"dynamic\\",\\"address_map\\":\\"1 Youge Street,\\\\nToronto, ON\\",\\"zoom_map\\":\\"15\\",\\"w_map\\":\\"100\\",\\"w_map_unit\\":\\"%\\",\\"w_map_static\\":\\"500\\",\\"h_map\\":\\"200\\",\\"type_map\\":\\"ROADMAP\\",\\"scrollwheel_map\\":\\"disable\\",\\"draggable_map\\":\\"enable\\",\\"draggable_disable_mobile_map\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"map_control\\":\\"yes\\",\\"map_provider\\":\\"google\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"2\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"2\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_top_style\\":\\"none\\",\\"border_left_color\\":\\"#f4f4f4\\",\\"border_left_width\\":\\"1\\"}},{\\"element_id\\":\\"990211d\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ace62ad\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h4>Working Hours<\\\\/h4>\\\\n<p>Monday : 09 - 20<\\\\/p>\\\\n<p>Tuesday  : 09 - 20<\\\\/p>\\\\n<p>Wednesday :  09 - 20<\\\\/p>\\\\n<p>Thursday : 09 - 20<\\\\/p>\\\\n<p>Friday : 09 - 20<\\\\/p>\\\\n<p>Saturday : 09 - 27<\\\\/p>\\\\n<p>Sunday  -<\\\\/p>\\",\\"stick_at_position\\":\\"top\\"}}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"3\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left\\":\\"2\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"left\\",\\"border_left_color\\":\\"#f4f4f4\\",\\"border_left_width\\":\\"1\\"}},{\\"element_id\\":\\"90787bb\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cea516c\\",\\"mod_settings\\":{\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"style_image\\":\\"image-center\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/contact-image.jpg\\",\\"width_image\\":\\"500\\",\\"param_image\\":\\"regular\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"custom_parallax_scroll_reverse\\":\\"reverse\\",\\"stick_at_position\\":\\"top\\"}}]}],\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}},{\\"element_id\\":\\"3c40321\\",\\"cols\\":[{\\"element_id\\":\\"6e0ebdf\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"0c7fd36\\",\\"mod_settings\\":{\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_labels\\":\\"#000000\\",\\"background_color_inputs\\":\\"#f7f7f7\\",\\"font_color_inputs\\":\\"#000000\\",\\"border_inputs-type\\":\\"all\\",\\"border_inputs_top_style\\":\\"none\\",\\"border_send-type\\":\\"top\\",\\"border_success_message-type\\":\\"top\\",\\"border_error_message-type\\":\\"top\\",\\"layout_contact\\":\\"animated-label\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_label\\":\\"Your Name\\",\\"field_email_label\\":\\"Your Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_subject_require\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_message_label\\":\\"Message\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_order\\":\\"{}\\",\\"field_send_label\\":\\"Send Message\\",\\"field_send_align\\":\\"right\\",\\"stick_at_position\\":\\"top\\",\\"field_email_active\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_sendcopy_active\\":\\"\\",\\"field_captcha_active\\":\\"\\",\\"field_email_require\\":\\"\\",\\"field_name_require\\":\\"\\",\\"contact_sent_from\\":\\"enable\\",\\"post_author\\":\\"\\",\\"send_to_admins\\":\\"true\\"}}]}],\\"styling\\":{\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"2\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 41,
  'post_date' => '2018-11-22 06:54:57',
  'post_date_gmt' => '2018-11-22 06:54:57',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/slide1-image-1600x715-30x30.jpg" width="30" height="30" /> <h3 data-show-transition="up" data-show-duration="1000" data-hide-transition="up" data-hide-duration="1000">Welcome</h3> <p>Shop over thousands of hand craft products</p> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/slide2-image-1600x715-30x30.jpg" width="30" height="30" /> <h3 data-show-transition="up" data-show-duration="1000" data-hide-transition="up" data-hide-duration="1000">New Arrivals</h3> <p>New collection of Home series</p> 
 
 <ul> <li>
 <a href="https://themify.me/demo/themes/shoppe-craft/product-category/technology/"> <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/drone-1.jpg" alt="Technology" width="300" height="300" /> </a> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/technology/"> <h3> Technology </h3> </a> <ul> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/technology/smart-watch/"> Smart Watch </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/technology/mobile/"> Mobile </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/technology/computer/"> Computer </a> </li> </ul> </li> <li>
 <a href="https://themify.me/demo/themes/shoppe-craft/product-category/office/"> <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/office.jpg" alt="Office" width="300" height="300" /> </a> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/office/"> <h3> Office </h3> </a> <ul> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/office/docks-cases/"> Docks &amp; Cases </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/office/lighting/"> Lighting </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/office/decor/"> Decor </a> </li> </ul> </li> <li>
 <a href="https://themify.me/demo/themes/shoppe-craft/product-category/furniture/"> <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/furniture.jpg" alt="Furniture" width="300" height="300" /> </a> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/furniture/"> <h3> Furniture </h3> </a> <ul> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/furniture/storage/"> Storage </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/furniture/lamp/"> Lamp </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/furniture/chair/"> Chair </a> </li> </ul> </li> <li>
 <a href="https://themify.me/demo/themes/shoppe-craft/product-category/accessories/"> <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/accesories.jpg" alt="Accessories" width="300" height="300" /> </a> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/accessories/"> <h3> Accessories </h3> </a> <ul> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/accessories/watches/"> Watches </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/accessories/vase/"> Vase </a> </li> <li> <a href="https://themify.me/demo/themes/shoppe-craft/product-category/accessories/jewellery/"> Jewellery </a> </li> </ul> </li> </ul> 
 <h3>Trending</h3> 
 <ul >
 <li data-product-id="112"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/pandora-2018-woman-necklace/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace-300x331.jpg" width="300" height="331" alt="woman-necklace" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/pandora-2018-woman-necklace/"> <h3>Pandora 2018 Woman Necklace</h3> &#36;790.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=112" data-quantity="1" data-product_id="112" data-product_sku="" aria-label="Add &ldquo;Pandora 2018 Woman Necklace&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=112&#038;action=edit">Edit</a>] <a data-id="112" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=112"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/pandora-2018-woman-necklace/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace&#038;text=Pandora+2018+Woman+Necklace\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace&#038;t=Pandora+2018+Woman+Necklace&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace&#038;description=Pandora+2018+Woman+Necklace&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fwoman-necklace.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fpandora-2018-woman-necklace&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="9"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/9/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase-300x331.jpg" width="300" height="331" alt="blue-glass-vase" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/9/"> <h3>Blue and Green Art Glass Vase</h3> &#36;150.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=9" data-quantity="1" data-product_id="9" data-product_sku="" aria-label="Add &ldquo;Blue and Green Art Glass Vase&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=9&#038;action=edit">Edit</a>] <a data-id="9" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=9"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/9/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9&#038;text=Blue+and+Green+Art+Glass+Vase\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9&#038;t=Blue+and+Green+Art+Glass+Vase&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9&#038;description=Blue+and+Green+Art+Glass+Vase&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fblue-glass-vase.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F9&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="26"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/black-vintage-style-lamp/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp-300x331.jpg" width="300" height="331" alt="vintage-lamp" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/black-vintage-style-lamp/"> <h3>Black Vintage Style Lamp</h3> &#36;125.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=26" data-quantity="1" data-product_id="26" data-product_sku="" aria-label="Add &ldquo;Black Vintage Style Lamp&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=26&#038;action=edit">Edit</a>] <a data-id="26" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=26"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/black-vintage-style-lamp/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp&#038;text=Black+Vintage+Style+Lamp\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp&#038;t=Black+Vintage+Style+Lamp&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp&#038;description=Black+Vintage+Style+Lamp&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fvintage-lamp.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fblack-vintage-style-lamp&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="27"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/yellow-single-sofa/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa-300x331.jpg" width="300" height="331" alt="vintage-yellow-single-sofa" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/yellow-single-sofa/"> <h3>Yellow Single Sofa</h3> &#36;250.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=27" data-quantity="1" data-product_id="27" data-product_sku="" aria-label="Add &ldquo;Yellow Single Sofa&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=27&#038;action=edit">Edit</a>] <a data-id="27" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=27"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/yellow-single-sofa/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa&#038;text=Yellow+Single+Sofa\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa&#038;t=Yellow+Single+Sofa&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa&#038;description=Yellow+Single+Sofa&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fvintage-yellow-single-sofa.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fyellow-single-sofa&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="28"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/1970-wood-cabinet/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet-300x331.jpg" width="300" height="331" alt="wood-cuppboard-cabinet" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/1970-wood-cabinet/"> <h3>1970 Wood Cabinet</h3> &#36;375.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=28" data-quantity="1" data-product_id="28" data-product_sku="" aria-label="Add &ldquo;1970 Wood Cabinet&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=28&#038;action=edit">Edit</a>] <a data-id="28" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=28"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/1970-wood-cabinet/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet&#038;text=1970+Wood+Cabinet\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet&#038;t=1970+Wood+Cabinet&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet&#038;description=1970+Wood+Cabinet&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fwood-cuppboard-cabinet.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2F1970-wood-cabinet&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="30"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/handmade-unique-desk-lamp/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp-300x331.jpg" width="300" height="331" alt="wood-craft-lamp" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/handmade-unique-desk-lamp/"> <h3>Handmade Unique Desk Lamp</h3> &#36;125.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=30" data-quantity="1" data-product_id="30" data-product_sku="" aria-label="Add &ldquo;Handmade Unique Desk Lamp&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=30&#038;action=edit">Edit</a>] <a data-id="30" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=30"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/handmade-unique-desk-lamp/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp&#038;text=Handmade+Unique+Desk+Lamp\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp&#038;t=Handmade+Unique+Desk+Lamp&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp&#038;description=Handmade+Unique+Desk+Lamp&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fwood-craft-lamp.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fhandmade-unique-desk-lamp&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="29"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/chicago-wood-single-chair/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair-300x331.jpg" width="300" height="331" alt="unique-wood-chair" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/chicago-wood-single-chair/"> <h3>Chicago Wood Single Chair</h3> &#36;450.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=29" data-quantity="1" data-product_id="29" data-product_sku="" aria-label="Add &ldquo;Chicago Wood Single Chair&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=29&#038;action=edit">Edit</a>] <a data-id="29" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=29"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/chicago-wood-single-chair/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair&#038;text=Chicago+Wood+Single+Chair\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair&#038;t=Chicago+Wood+Single+Chair&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair&#038;description=Chicago+Wood+Single+Chair&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Funique-wood-chair.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fchicago-wood-single-chair&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="31"> <figure ><a href="https://themify.me/demo/themes/shoppe-craft/product/grey-vintage-sofa/"><img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa-300x331.jpg" width="300" height="331" alt="vintage-grey-sofa" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa-300x331.jpg 300w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa.jpg 680w" sizes="(max-width: 300px) 100vw, 300px" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-craft/product/grey-vintage-sofa/"> <h3>Grey Vintage Sofa</h3> &#36;780.00 </a> <a href="/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?add-to-cart=31" data-quantity="1" data-product_id="31" data-product_sku="" aria-label="Add &ldquo;Grey Vintage Sofa&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-craft/wp-admin/post.php?post=31&#038;action=edit">Edit</a>] <a data-id="31" onclick="javascript:void(0)" href="https://themify.me/demo/themes/shoppe-craft/wp-admin/admin-ajax.php?action=themify_add_wishlist&id=31"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-craft/wp-content/plugins/woocommerce/assets/images/placeholder.png" href="https://themify.me/demo/themes/shoppe-craft/product/grey-vintage-sofa/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa&#038;text=Grey+Vintage+Sofa\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa&#038;t=Grey+Vintage+Sofa&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa&#038;description=Grey+Vintage+Sofa&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Ffiles%2F2018%2F11%2Fvintage-grey-sofa.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//plus.google.com/share?hl=en-US&#038;url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa\',\'googlePlus\',\'toolbar=0, status=0, width=900, height=500\')" title="Google+" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-craft%2Fproduct%2Fgrey-vintage-sofa&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> </ul>
 
 <a href="https://themify.me/demo/themes/shoppe-craft/shop/" >View All Products</a> 
 <h3>This Month Special</h3> <p>Armchair with removable cover with armrests</p> 
 <a href="https://themify.me/demo/themes/shoppe-craft/shop" >Buy Now</a> 
 <img src="https://themify.me/demo/themes/shoppe-craft/files/2018/11/italian-saba-chair-600x489.png" width="600" height="489" alt="italian saba chair" srcset="https://themify.me/demo/themes/shoppe-craft/files/2018/11/italian-saba-chair-600x489.png 600w, https://themify.me/demo/themes/shoppe-craft/files/2018/11/italian-saba-chair.png 622w" sizes="(max-width: 600px) 100vw, 600px" /> 
 <h3>Exclusive <br />Discounts</h3> <p>Subscribe to our Newsletter for exclusive discounts and offers.</p> 
 <form action="//themify.us2.list-manage.com/subscribe/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de" method="post" id="mc-embedded-subscribe-form" name="mc-embedded-subscribe-form" target="_blank" novalidate> <input type="email" value="" name="EMAIL" id="mce-EMAIL"> <input type="submit" value="Subscribe" name="subscribe" id="mc-embedded-subscribe"> <input type="text" name="b_03462cf158e86ea00590274ab_0f2a95e5de" tabindex="-1" value=""> </form><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2018-12-03 00:49:46',
  'post_modified_gmt' => '2018-12-03 00:49:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?page_id=41',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ab66eac\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e5267ef\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"pro-slider\\",\\"element_id\\":\\"f0cf78f\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"s_t_c_b_c\\":\\"#fcb424_0.82\\",\\"s_t_c_p_top\\":\\"3\\",\\"s_t_c_p_top_unit\\":\\"%\\",\\"s_t_c_p_right\\":\\"3\\",\\"s_t_c_p_right_unit\\":\\"%\\",\\"s_t_c_p_bottom\\":\\"2\\",\\"s_t_c_p_bottom_unit\\":\\"%\\",\\"s_t_c_p_left\\":\\"3\\",\\"s_t_c_p_left_unit\\":\\"%\\",\\"s_t_c_b-type\\":\\"left\\",\\"s_t_c_b_left_color\\":\\"#ffffff\\",\\"s_t_c_b_left_width\\":\\"8\\",\\"f_c_title\\":\\"#ffffff\\",\\"font_size_title_unit\\":\\"em\\",\\"f_c_text\\":\\"#ffffff\\",\\"text_font_size\\":\\"1.2\\",\\"text_font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_arrow_apply_all\\":\\"1\\",\\"checkbox_p_b_apply_all\\":\\"1\\",\\"b_b-type\\":\\"top\\",\\"checkbox_margin_button_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"s_t_c_p_top_unit\\":\\"%\\",\\"s_t_c_p_right_unit\\":\\"%\\",\\"s_t_c_p_bottom\\":\\"1\\",\\"s_t_c_p_bottom_unit\\":\\"%\\",\\"s_t_c_p_left\\":\\"4\\",\\"s_t_c_p_left_unit\\":\\"%\\",\\"s_t_c_b-type\\":\\"left\\",\\"s_t_c_b_left_color\\":\\"#ffffff\\",\\"s_t_c_b_left_width\\":\\"8\\",\\"font_size_title\\":\\"1.5\\",\\"font_size_title_unit\\":\\"em\\",\\"text_font_size\\":\\"1\\",\\"text_font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_arrow_apply_all\\":\\"1\\",\\"checkbox_p_b_apply_all\\":\\"1\\",\\"b_b-type\\":\\"top\\",\\"checkbox_margin_button_apply_all\\":\\"1\\"},\\"builder_slider_pro_slides\\":[{\\"builder_ps_layout\\":\\"bsp-slide-content-right\\",\\"builder_ps_slide_type\\":\\"Image\\",\\"builder-ps-bg-image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/slide1-image.jpg\\",\\"builder_ps_heading\\":\\"Welcome\\",\\"builder_ps_text\\":\\"<p>Shop over thousands of hand craft products<\\\\/p>\\",\\"builder_ps_button_action_type\\":\\"custom\\",\\"builder_ps_tranzition\\":\\"slideTop\\",\\"builder_ps_tranzition_duration\\":\\"normal\\",\\"builder_ps_h3s_timer\\":\\"shortTop\\",\\"builder_ps_h3s_tranzition_duration\\":\\"normal\\",\\"builder_ps_h3e_timer\\":\\"shortTopOut\\",\\"builder_ps_h3e_tranzition_duration\\":\\"normal\\",\\"builder_ps_ps_timer\\":\\"shortTop\\",\\"builder_ps_ps_tranzition_duration\\":\\"normal\\",\\"builder_ps_pe_timer\\":\\"shortTopOut\\",\\"builder_ps_pe_tranzition_duration\\":\\"normal\\",\\"builder_ps_as_timer\\":\\"shortTop\\",\\"builder_ps_as_tranzition_duration\\":\\"normal\\",\\"builder_ps_ae_timer\\":\\"shortTopOut\\",\\"builder_ps_ae_tranzition_duration\\":\\"normal\\",\\"builder_ps_imgs_timer\\":\\"shortTop\\",\\"builder_ps_imgs_tranzition_duration\\":\\"normal\\",\\"builder_ps_imge_timer\\":\\"shortTopOut\\",\\"builder_ps_imge_tranzition_duration\\":\\"normal\\"},{\\"builder_ps_layout\\":\\"bsp-slide-content-right\\",\\"builder_ps_slide_type\\":\\"Image\\",\\"builder-ps-bg-image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/slide2-image.jpg\\",\\"builder_ps_heading\\":\\"New Arrivals\\",\\"builder_ps_text\\":\\"<p>New collection of Home series<\\\\/p>\\",\\"builder_ps_button_action_type\\":\\"custom\\",\\"builder_ps_tranzition\\":\\"slideTop\\",\\"builder_ps_tranzition_duration\\":\\"normal\\",\\"builder_ps_h3s_timer\\":\\"shortTop\\",\\"builder_ps_h3s_tranzition_duration\\":\\"normal\\",\\"builder_ps_h3e_timer\\":\\"shortTopOut\\",\\"builder_ps_h3e_tranzition_duration\\":\\"normal\\",\\"builder_ps_ps_timer\\":\\"shortTop\\",\\"builder_ps_ps_tranzition_duration\\":\\"normal\\",\\"builder_ps_pe_timer\\":\\"shortTopOut\\",\\"builder_ps_pe_tranzition_duration\\":\\"normal\\",\\"builder_ps_as_timer\\":\\"shortTop\\",\\"builder_ps_as_tranzition_duration\\":\\"normal\\",\\"builder_ps_ae_timer\\":\\"shortTopOut\\",\\"builder_ps_ae_tranzition_duration\\":\\"normal\\",\\"builder_ps_imgs_timer\\":\\"shortTop\\",\\"builder_ps_imgs_tranzition_duration\\":\\"normal\\",\\"builder_ps_imge_timer\\":\\"shortTopOut\\",\\"builder_ps_imge_tranzition_duration\\":\\"normal\\"}],\\"builder_ps_triggers_position\\":\\"standard\\",\\"builder_ps_triggers_type\\":\\"thumb\\",\\"builder_ps_thumb_width\\":\\"30\\",\\"builder_ps_thumb_height\\":\\"30\\",\\"builder_ps_aa\\":\\"off\\",\\"builder_ps_hover_pause\\":\\"pause\\",\\"builder_ps_width\\":\\"1600\\",\\"builder_ps_height\\":\\"700\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"815c2e2\\",\\"row_order\\":\\"1\\",\\"cols\\":[{\\"element_id\\":\\"33cdbb1\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"product-categories\\",\\"element_id\\":\\"f1c58bf\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"columns\\":\\"4\\",\\"child_of\\":\\"top-level\\",\\"orderby\\":\\"name\\",\\"order\\":\\"desc\\",\\"hide_empty\\":\\"yes\\",\\"pad_counts\\":\\"no\\",\\"display\\":\\"subcategories\\",\\"latest_products\\":\\"3\\",\\"subcategories_number\\":\\"3\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"23b9f61\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"3a6be98\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"3a6be98\\",\\"row_order\\":\\"2\\",\\"cols\\":[{\\"element_id\\":\\"e1c302d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"23b9f61\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Trending<\\\\/h3>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"d64b475\\",\\"mod_settings\\":{\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"checkbox_p_p_ctr_apply_all\\":\\"1\\",\\"checkbox_m_p_ctr_apply_all\\":\\"1\\",\\"b_p_ctr-type\\":\\"top\\",\\"checkbox_p_p_ct_apply_all\\":\\"1\\",\\"checkbox_m_p_ct_apply_all\\":\\"1\\",\\"b_p_ct-type\\":\\"top\\",\\"checkbox_p_p_t_apply_all\\":\\"1\\",\\"checkbox_m_p_t_apply_all\\":\\"1\\",\\"b_p_t-type\\":\\"top\\",\\"checkbox_p_p_p_apply_all\\":\\"1\\",\\"checkbox_m_p_p_apply_all\\":\\"1\\",\\"b_p_p-type\\":\\"top\\",\\"checkbox_p_p_b_apply_all\\":\\"1\\",\\"checkbox_m_p_b_apply_all\\":\\"1\\",\\"b_p_b-type\\":\\"top\\",\\"query_products\\":\\"all\\",\\"category_products\\":\\"0|multiple\\",\\"hide_child_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_outofstock_products\\":\\"no\\",\\"post_per_page_products\\":\\"8\\",\\"orderby_products\\":\\"date\\",\\"order_products\\":\\"desc\\",\\"template_products\\":\\"list\\",\\"layout_products\\":\\"grid4\\",\\"layout_slider\\":\\"slider-default\\",\\"visible_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"auto_scroll_opt_slider\\":\\"off\\",\\"scroll_opt_slider\\":\\"1\\",\\"speed_opt_slider\\":\\"normal\\",\\"effect_slider\\":\\"scroll\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"wrap_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"show_arrow_slider\\":\\"yes\\",\\"height_slider\\":\\"variable\\",\\"description_products\\":\\"none\\",\\"hide_feat_img_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_page_nav_products\\":\\"yes\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"88d5c73\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"border-type\\":\\"top\\",\\"link_border-type\\":\\"top\\",\\"buttons_size\\":\\"normal\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"View All Products\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/shop\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"ab66eac\\",\\"unstick_when_el_mod_id\\":\\"f0cf78f\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"b704f59\\",\\"row_order\\":\\"3\\",\\"cols\\":[{\\"element_id\\":\\"b34db3c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"element_id\\":\\"5dbd52d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c3c8f56\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col2-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"01246e2\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>This Month Special<\\\\/h3>\\\\n<p>Armchair with removable cover with armrests<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"30\\",\\"padding_bottom\\":\\"30\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"79a31e7\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col2-1\\"}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#f7f7f7\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin-top\\":\\"30\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"ab66eac\\",\\"unstick_when_el_mod_id\\":\\"f0cf78f\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"f003c28\\",\\"row_order\\":\\"4\\",\\"cols\\":[{\\"element_id\\":\\"09728b2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8f8b970\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-30\\",\\"margin_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"text_align\\":\\"center\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_left_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_padding_link_apply_all\\":\\"1\\",\\"checkbox_link_margin_apply_all\\":\\"1\\",\\"link_border-type\\":\\"top\\"},\\"buttons_size\\":\\"large\\",\\"buttons_shape\\":\\"squared\\",\\"display\\":\\"buttons-horizontal\\",\\"content_button\\":[{\\"label\\":\\"Buy Now\\",\\"link\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/shop\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}},{\\"element_id\\":\\"60744af\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"0bcf8fe\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"-40\\",\\"margin_top_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_top\\":\\"0\\",\\"border-type\\":\\"top\\",\\"checkbox_title_margin_apply_all\\":\\"1\\",\\"checkbox_i_t_p_apply_all\\":\\"1\\",\\"checkbox_i_t_m_apply_all\\":\\"1\\",\\"i_t_b-type\\":\\"top\\",\\"checkbox_c_p_apply_all\\":\\"1\\"},\\"style_image\\":\\"image-top\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-craft\\\\/files\\\\/2018\\\\/11\\\\/italian-saba-chair-600x489.png\\",\\"width_image\\":\\"600\\",\\"height_image\\":\\"489\\",\\"param_image\\":\\"regular\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}]}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_bottom\\":\\"7\\",\\"padding_bottom_unit\\":\\"%\\",\\"border-type\\":\\"top\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}},{\\"element_id\\":\\"dee7ed2\\",\\"row_order\\":\\"5\\",\\"cols\\":[{\\"element_id\\":\\"c69f908\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"7a0f496\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color\\":\\"#000000\\",\\"font_gradient_color-gradient\\":\\"0% rgb(0, 0, 0)|100% rgb(255, 255, 255)\\",\\"font_size\\":\\"1.1\\",\\"font_size_unit\\":\\"em\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_size_h3\\":\\"50\\",\\"line_height_h3\\":\\"50\\",\\"font_weight_h3\\":\\"bold\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"font_color_type_h5\\":\\"font_color_h5_solid\\",\\"font_color_type_h6\\":\\"font_color_h6_solid\\",\\"checkbox_dropcap_padding_apply_all\\":\\"1\\",\\"checkbox_dropcap_margin_apply_all\\":\\"1\\",\\"dropcap_border-type\\":\\"top\\",\\"content_text\\":\\"<h3>Exclusive <br \\\\/>Discounts<\\\\/h3>\\\\n<p>Subscribe to our Newsletter for exclusive discounts and offers.<\\\\/p>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\"}}],\\"styling\\":{\\"background_type\\":\\"image\\",\\"background_slider_size\\":\\"large\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_speed\\":\\"2000\\",\\"background_video_options\\":\\"mute\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"background_color\\":\\"#ffc001\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"210\\",\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"5\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"breakpoint_mobile\\":{\\"background_type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_attachment\\":\\"scroll\\",\\"background_position\\":\\"center-center\\",\\"cover_color-type\\":\\"color\\",\\"cover_color_hover-type\\":\\"hover_color\\",\\"background_repeat_inner\\":\\"repeat\\",\\"background_attachment_inner\\":\\"scroll\\",\\"background_position_inner\\":\\"center-center\\",\\"checkbox_padding_inner_apply_all\\":\\"1\\",\\"border_inner-type\\":\\"top\\",\\"top-frame_type\\":\\"top-presets\\",\\"bottom-frame_type\\":\\"bottom-presets\\",\\"left-frame_type\\":\\"left-presets\\",\\"right-frame_type\\":\\"right-presets\\",\\"padding_top_unit\\":\\"%\\",\\"padding_right\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}},{\\"element_id\\":\\"bd7c540\\",\\"column_order\\":\\"1\\",\\"grid_class\\":\\"col4-1\\",\\"modules\\":[{\\"mod_name\\":\\"plain-text\\",\\"element_id\\":\\"b0ef177\\",\\"mod_settings\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\",\\"plain_text\\":\\"<div id=\\\\\\\\\\\\\\"mc_embed_signup\\\\\\\\\\\\\\">\\\\n\\\\t<form action=\\\\\\\\\\\\\\"\\\\/\\\\/themify.us2.list-manage.com\\\\/subscribe\\\\/post?u=03462cf158e86ea00590274ab&amp;id=0f2a95e5de\\\\\\\\\\\\\\" method=\\\\\\\\\\\\\\"post\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"mc-embedded-subscribe-form\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"validate\\\\\\\\\\\\\\" target=\\\\\\\\\\\\\\"_blank\\\\\\\\\\\\\\" novalidate>\\\\n\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mc_embed_signup_scroll\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"mc-field-group\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"EMAIL\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"required email\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-EMAIL\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"submit\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"Subscribe\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"subscribe\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mc-embedded-subscribe\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"button\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<div id=\\\\\\\\\\\\\\"mce-responses\\\\\\\\\\\\\\" class=\\\\\\\\\\\\\\"clear\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-error-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t\\\\t<div class=\\\\\\\\\\\\\\"response\\\\\\\\\\\\\\" id=\\\\\\\\\\\\\\"mce-success-response\\\\\\\\\\\\\\" style=\\\\\\\\\\\\\\"display:none\\\\\\\\\\\\\\"><\\\\/div>\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t\\\\t<!-- real people should not fill this in and expect good things - do not remove this or risk form bot signups-->\\\\n\\\\t\\\\t\\\\t<div style=\\\\\\\\\\\\\\"position: absolute; left: -5000px;\\\\\\\\\\\\\\" aria-hidden=\\\\\\\\\\\\\\"true\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t\\\\t<input type=\\\\\\\\\\\\\\"text\\\\\\\\\\\\\\" name=\\\\\\\\\\\\\\"b_03462cf158e86ea00590274ab_0f2a95e5de\\\\\\\\\\\\\\" tabindex=\\\\\\\\\\\\\\"-1\\\\\\\\\\\\\\" value=\\\\\\\\\\\\\\"\\\\\\\\\\\\\\">\\\\n\\\\t\\\\t\\\\t<\\\\/div>\\\\n\\\\t\\\\t<\\\\/div>\\\\n\\\\t<\\\\/form>\\\\n<\\\\/div>\\\\n<script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\' src=\\\\\\\\\\\'\\\\/\\\\/s3.amazonaws.com\\\\/downloads.mailchimp.com\\\\/js\\\\/mc-validate.js\\\\\\\\\\\'><\\\\/script><script type=\\\\\\\\\\\'text\\\\/javascript\\\\\\\\\\\'>(function($) {window.fnames = new Array(); window.ftypes = new Array();fnames[0]=\\\\\\\\\\\'EMAIL\\\\\\\\\\\';ftypes[0]=\\\\\\\\\\\'email\\\\\\\\\\\';fnames[1]=\\\\\\\\\\\'FNAME\\\\\\\\\\\';ftypes[1]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[2]=\\\\\\\\\\\'LNAME\\\\\\\\\\\';ftypes[2]=\\\\\\\\\\\'text\\\\\\\\\\\';fnames[5]=\\\\\\\\\\\'HOMEPAGE\\\\\\\\\\\';ftypes[5]=\\\\\\\\\\\'text\\\\\\\\\\\';}(jQuery));var $mcj = jQuery.noConflict(true);<\\\\/script>\\\\n\\\\n<style>\\\\n#pagewrap #mc_embed_signup {\\\\n\\\\tmargin-left: -200px;\\\\n}\\\\n#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"] {\\\\n\\\\twidth: 60%;\\\\n\\\\tborder: none;\\\\n\\\\tbox-shadow: 0px 6px 20px rgba(0,0,0,0.1);\\\\n\\\\tpadding: 1em;\\\\n\\\\tfont-size: 1em;\\\\n}\\\\n#pagewrap #mc_embed_signup .button {\\\\n\\\\tfont-size: 0.875em;\\\\n\\\\ttext-transform: none;\\\\n\\\\ttext-indent: 0em;\\\\n\\\\tletter-spacing: 0;\\\\n\\\\tpadding: 1.35em 3.18em;\\\\n\\\\tposition: static;\\\\n}\\\\n@media (max-width: 880px) {\\\\n\\\\t#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"],\\\\n\\\\t#pagewrap #mc_embed_signup .button {\\\\n\\\\t\\\\twidth:90%;\\\\n\\\\t}\\\\n\\\\t#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"]{\\\\n\\\\t\\\\tmargin: 10px 0;\\\\n\\\\t}\\\\n}\\\\n@media (max-width: 680px) {\\\\n\\\\t#pagewrap #mc_embed_signup {\\\\n\\\\t\\\\tmargin-left: 0;\\\\n\\\\t\\\\tmargin-top: -40px;\\\\n\\\\t}\\\\n\\\\t#pagewrap #mc_embed_signup input[type=\\\\\\\\\\\\\\"email\\\\\\\\\\\\\\"],\\\\n\\\\t#pagewrap #mc_embed_signup .button {\\\\n\\\\t\\\\tdisplay: block;\\\\n\\\\t\\\\tmargin-left: auto;\\\\n\\\\t\\\\tmargin-right: auto;\\\\n\\\\t}\\\\n}\\\\n<\\\\/style>\\",\\"stick_at_position\\":\\"top\\",\\"unstick_when_element\\":\\"builder_end\\",\\"unstick_when_el_row_id\\":\\"815c2e2\\",\\"unstick_when_el_mod_id\\":\\"f1c58bf\\",\\"unstick_when_condition\\":\\"hits\\",\\"unstick_when_pos\\":\\"this\\",\\"breakpoint_mobile\\":{\\"background_image-type\\":\\"image\\",\\"background_repeat\\":\\"repeat\\",\\"background_position\\":\\"left-top\\",\\"font_color_type\\":\\"font_color_solid\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"margin_left_unit\\":\\"%\\",\\"checkbox_margin_apply_all\\":\\"1\\",\\"border-type\\":\\"top\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}},{\\"element_id\\":\\"1919d54\\",\\"row_order\\":\\"6\\",\\"cols\\":[{\\"element_id\\":\\"ead01c6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2018-11-21 06:27:45',
  'post_date_gmt' => '2018-11-21 06:27:45',
  'post_content' => '[woocommerce_my_account]',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2018-11-21 06:27:45',
  'post_modified_gmt' => '2018-11-21 06:27:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 4,
  'post_date' => '2018-11-21 06:27:45',
  'post_date_gmt' => '2018-11-21 06:27:45',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2018-11-21 06:27:45',
  'post_modified_gmt' => '2018-11-21 06:27:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 195,
  'post_date' => '2018-11-26 02:48:48',
  'post_date_gmt' => '2018-11-26 02:48:48',
  'post_content' => '',
  'post_title' => 'Wishlist',
  'post_excerpt' => '',
  'post_name' => 'wishlist',
  'post_modified' => '2018-11-26 02:50:01',
  'post_modified_gmt' => '2018-11-26 02:50:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?page_id=195',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"26972b0\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"064e0ff\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 112,
  'post_date' => '2018-11-23 11:35:37',
  'post_date_gmt' => '2018-11-23 11:35:37',
  'post_content' => 'Molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Pandora 2018 Woman Necklace',
  'post_excerpt' => 'Quidem  et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.
',
  'post_name' => 'pandora-2018-woman-necklace',
  'post_modified' => '2018-11-23 11:37:39',
  'post_modified_gmt' => '2018-11-23 11:37:39',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=112',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542972921:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f12013b\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"551e0bf\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '790',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '790',
    '_thumbnail_id' => '119',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, jewellery',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/woman-necklace.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 9,
  'post_date' => '2018-11-21 06:47:30',
  'post_date_gmt' => '2018-11-21 06:47:30',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.
',
  'post_title' => 'Blue and Green Art Glass Vase',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => '9',
  'post_modified' => '2018-11-23 11:33:15',
  'post_modified_gmt' => '2018-11-23 11:33:15',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=9',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1561359677:172',
    '_edit_last' => '172',
    '_regular_price' => '150',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '150',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e19bccc\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"79eaa7a\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '12',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase.jpg',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, vase',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/blue-glass-vase.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 26,
  'post_date' => '2018-11-20 07:02:33',
  'post_date_gmt' => '2018-11-20 07:02:33',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Black Vintage Style Lamp',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.',
  'post_name' => 'black-vintage-style-lamp',
  'post_modified' => '2018-11-23 11:56:24',
  'post_modified_gmt' => '2018-11-23 11:56:24',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=26',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974184:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e603fe6\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b1983a0\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '21',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp.jpg',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '125',
    '_wp_old_date' => '2018-11-21',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'lamp, lighting, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-lamp.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 27,
  'post_date' => '2018-11-19 07:03:16',
  'post_date_gmt' => '2018-11-19 07:03:16',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Yellow Single Sofa',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.',
  'post_name' => 'yellow-single-sofa',
  'post_modified' => '2018-11-23 11:56:40',
  'post_modified_gmt' => '2018-11-23 11:56:40',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=27',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974200:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"051a971\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"210c499\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '23',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '250',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'chair, decor, furniture, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-yellow-single-sofa.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 28,
  'post_date' => '2018-11-18 07:04:33',
  'post_date_gmt' => '2018-11-18 07:04:33',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => '1970 Wood Cabinet',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => '1970-wood-cabinet',
  'post_modified' => '2019-06-15 06:16:44',
  'post_modified_gmt' => '2019-06-15 06:16:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=28',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543060392:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"0669091\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"f2ae574\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '25',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.6.2',
    '_price' => '375',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, storage',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-cuppboard-cabinet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 30,
  'post_date' => '2018-11-17 07:10:38',
  'post_date_gmt' => '2018-11-17 07:10:38',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit.',
  'post_title' => 'Handmade Unique Desk Lamp',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'handmade-unique-desk-lamp',
  'post_modified' => '2018-11-23 11:57:06',
  'post_modified_gmt' => '2018-11-23 11:57:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=30',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974226:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"67b5896\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"a209fb6\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '24',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '125',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, lamp, lighting, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-craft-lamp.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 29,
  'post_date' => '2018-11-17 07:07:11',
  'post_date_gmt' => '2018-11-17 07:07:11',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Chicago Wood Single Chair',
  'post_excerpt' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.
',
  'post_name' => 'chicago-wood-single-chair',
  'post_modified' => '2018-11-23 11:57:26',
  'post_modified_gmt' => '2018-11-23 11:57:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=29',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974246:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"9cdbd3e\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"394174b\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '17',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '450',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '450',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'chair, decor, furniture, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-chair.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 31,
  'post_date' => '2018-11-16 07:12:13',
  'post_date_gmt' => '2018-11-16 07:12:13',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Grey Vintage Sofa',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'grey-vintage-sofa',
  'post_modified' => '2018-11-23 11:57:43',
  'post_modified_gmt' => '2018-11-23 11:57:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=31',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974263:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3de1461\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4130827\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '20',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '780',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '780',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'chair, furniture',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-grey-sofa.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 32,
  'post_date' => '2018-11-15 07:13:33',
  'post_date_gmt' => '2018-11-15 07:13:33',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Mosaic Wood Cupboard',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'mosaic-wood-cupboard',
  'post_modified' => '2018-11-23 11:57:52',
  'post_modified_gmt' => '2018-11-23 11:57:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=32',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974272:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f28bf22\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"0a258a4\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '19',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-cuppboard-wood-cabinet.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '600',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '600',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'decor, furniture, office, storage',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vintage-cuppboard-wood-cabinet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 34,
  'post_date' => '2018-11-14 07:20:11',
  'post_date_gmt' => '2018-11-14 07:20:11',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Wood Rough Textured Cabinet',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => 'wood-rough-textured-cabinet',
  'post_modified' => '2018-11-24 11:53:46',
  'post_modified_gmt' => '2018-11-24 11:53:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=34',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543060426:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f1e1379\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"97c4fa7\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '16',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/square-wood-vintage-cabinet.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '780',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '780',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, storage',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/square-wood-vintage-cabinet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 33,
  'post_date' => '2018-11-14 07:17:31',
  'post_date_gmt' => '2018-11-14 07:17:31',
  'post_content' => ' Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Modern Wall Shelves',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'modern-wall-shelves',
  'post_modified' => '2018-11-23 11:58:29',
  'post_modified_gmt' => '2018-11-23 11:58:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=33',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974309:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"f00b140\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"c1d3e40\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '18',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-wall-rack.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '90',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '90',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, decor, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/unique-wood-wall-rack.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 35,
  'post_date' => '2018-11-13 07:29:08',
  'post_date_gmt' => '2018-11-13 07:29:08',
  'post_content' => 'Teleniti atque corrupti ero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum  quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.',
  'post_title' => 'Convex Single Desk Lamp',
  'post_excerpt' => 'Yeleniti atque corrupti olores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia.',
  'post_name' => 'convex-single-desk-lamp',
  'post_modified' => '2018-11-23 11:58:43',
  'post_modified_gmt' => '2018-11-23 11:58:43',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=35',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974323:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"18d7648\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"d377363\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '14',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/simple-retro-lamp.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '125',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, lamp',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/simple-retro-lamp.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 36,
  'post_date' => '2018-11-11 07:30:54',
  'post_date_gmt' => '2018-11-11 07:30:54',
  'post_content' => 'Deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. Excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum.',
  'post_title' => 'Retro and Vintage Single Chair',
  'post_excerpt' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias.',
  'post_name' => 'retro-and-vintage-single-chair',
  'post_modified' => '2018-11-23 11:58:51',
  'post_modified_gmt' => '2018-11-23 11:58:51',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=36',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974331:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"3cffa8f\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"795dd62\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '13',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/Retro-Chair.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '450',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '450',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'chair, furniture',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/Retro-Chair.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 37,
  'post_date' => '2018-11-10 07:33:11',
  'post_date_gmt' => '2018-11-10 07:33:11',
  'post_content' => 'Voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Vintage Cloth Art Pendant Light',
  'post_excerpt' => 'Numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_name' => 'vintage-cloth-art-pendant-light',
  'post_modified' => '2018-11-23 11:59:01',
  'post_modified_gmt' => '2018-11-23 11:59:01',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=37',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974341:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"d3e17b1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"df011f9\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '11',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/black-three-lamp-set.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '375',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, lamp, lighting, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/black-three-lamp-set.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 121,
  'post_date' => '2018-11-09 11:37:45',
  'post_date_gmt' => '2018-11-09 11:37:45',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Wood Men\'s Watch',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'wood-mens-watch',
  'post_modified' => '2018-11-23 11:59:07',
  'post_modified_gmt' => '2018-11-23 11:59:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=121',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974347:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"438525d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4b471ee\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '115',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/mens-wood-watch.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '500',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '500',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, watches',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/mens-wood-watch.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 38,
  'post_date' => '2018-11-08 07:35:40',
  'post_date_gmt' => '2018-11-08 07:35:40',
  'post_content' => 'Molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Flower Posy Glass Vase',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.',
  'post_name' => 'flower-posy-glass-vase',
  'post_modified' => '2018-11-23 11:33:25',
  'post_modified_gmt' => '2018-11-23 11:33:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=38',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542972805:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"96f057a\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8702e7f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '10',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/art-glass-vase.jpg',
    '_wp_old_date' => '2018-11-21',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '125',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, vase',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/art-glass-vase.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 122,
  'post_date' => '2018-11-06 11:40:12',
  'post_date_gmt' => '2018-11-06 11:40:12',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

',
  'post_title' => 'Artistic Cafe Lamp Pendant',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.

',
  'post_name' => 'artistic-cafe-lamp-pendant',
  'post_modified' => '2018-11-23 11:59:29',
  'post_modified_gmt' => '2018-11-23 11:59:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=122',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974369:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"d40209d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"067341f\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '120',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-lamp.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '250',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, lamp',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/wood-lamp.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 123,
  'post_date' => '2018-11-05 11:41:20',
  'post_date_gmt' => '2018-11-05 11:41:20',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Ceramics Cone Vase',
  'post_excerpt' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.

',
  'post_name' => 'ceramics-cone-vase',
  'post_modified' => '2018-11-23 11:59:36',
  'post_modified_gmt' => '2018-11-23 11:59:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=123',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974376:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"de2ad02\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"cffd7a2\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '118',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vase-plant.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '125',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, vase',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/vase-plant.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 124,
  'post_date' => '2018-11-04 11:43:09',
  'post_date_gmt' => '2018-11-04 11:43:09',
  'post_content' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias.

',
  'post_title' => '1960s Acrylic Prism Lamp',
  'post_excerpt' => 'Deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. Excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum.

',
  'post_name' => '1960s-acrylic-prism-lamp',
  'post_modified' => '2018-11-23 11:44:32',
  'post_modified_gmt' => '2018-11-23 11:44:32',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=124',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542973333:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"79355f1\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"eb5f832\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '116',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/retro-prism-lamp-pendant.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '250',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'furniture, lamp',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/retro-prism-lamp-pendant.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 126,
  'post_date' => '2018-11-03 11:46:14',
  'post_date_gmt' => '2018-11-03 11:46:14',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Swiss Handmade Watch For Men',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.

',
  'post_name' => 'swiss-handmade-watch-for-men',
  'post_modified' => '2018-11-23 12:00:02',
  'post_modified_gmt' => '2018-11-23 12:00:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=126',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542974402:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"caecb63\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e542ab3\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '114',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/mens-watch.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '600',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '600',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, watches',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/mens-watch.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 125,
  'post_date' => '2018-11-02 11:44:36',
  'post_date_gmt' => '2018-11-02 11:44:36',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.

',
  'post_title' => '1960 Medium High Wood Chair',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.

',
  'post_name' => '1960-medium-high-wood-chair',
  'post_modified' => '2018-11-23 12:00:34',
  'post_modified_gmt' => '2018-11-23 12:00:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=125',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1561359812:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ca220df\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"96b34a0\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '117',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/retro-wood-chair.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '375',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'chair, decor, furniture, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/retro-wood-chair.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 127,
  'post_date' => '2018-11-01 11:48:48',
  'post_date_gmt' => '2018-11-01 11:48:48',
  'post_content' => 'Teleniti atque corrupti ero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.',
  'post_title' => 'Viking Carving Amulet',
  'post_excerpt' => 'Yeleniti atque corrupti olores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia.',
  'post_name' => 'viking-carving-amulet',
  'post_modified' => '2018-11-23 11:50:22',
  'post_modified_gmt' => '2018-11-23 11:50:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=127',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1542973688:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a4366ce\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"8d7ff18\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '113',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/amulet.jpg',
    '_wp_old_date' => '2018-11-23',
    '_regular_price' => '90',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '90',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories, jewellery',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/amulet.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 141,
  'post_date' => '2018-10-24 03:29:17',
  'post_date_gmt' => '2018-10-24 03:29:17',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

',
  'post_title' => 'Zimo Gadget Dock',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'zimo-gadget-dock',
  'post_modified' => '2018-11-24 03:31:28',
  'post_modified_gmt' => '2018-11-24 03:31:28',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=141',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543030163:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"a2330c0\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"fc576ef\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '145',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iphone-dock.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '115',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '115',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'docks-cases, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iphone-dock.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 149,
  'post_date' => '2018-10-23 03:31:47',
  'post_date_gmt' => '2018-10-23 03:31:47',
  'post_content' => 'Molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus. Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae.Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Microsoft Surface Pro',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.',
  'post_name' => 'microsoft-surface-pro',
  'post_modified' => '2018-11-24 03:34:17',
  'post_modified_gmt' => '2018-11-24 03:34:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=149',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543030318:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"383f75c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"4981695\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '146',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/microsoft.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '1488',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '1488',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'mobile, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/microsoft.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 150,
  'post_date' => '2018-10-22 03:34:22',
  'post_date_gmt' => '2018-10-22 03:34:22',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Apple iPhone Xs Max 6.5',
  'post_excerpt' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.',
  'post_name' => 'apple-iphone-xs-max-6-5',
  'post_modified' => '2018-11-24 03:37:06',
  'post_modified_gmt' => '2018-11-24 03:37:06',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=150',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543030486:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"19a7e8d\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"1a94e9c\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '144',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPhone.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '1650',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '1650',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'mobile, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPhone.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 151,
  'post_date' => '2018-10-21 03:37:10',
  'post_date_gmt' => '2018-10-21 03:37:10',
  'post_content' => 'Teleniti atque corrupti ero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga.',
  'post_title' => 'iPad Pro Leather Case',
  'post_excerpt' => 'Yeleniti atque corrupti olores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia.',
  'post_name' => 'ipad-pro-leather-case',
  'post_modified' => '2018-11-24 03:38:47',
  'post_modified_gmt' => '2018-11-24 03:38:47',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=151',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543031111:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"4926ea3\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"10c06cf\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '143',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPad-pro-case.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '90',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '90',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'docks-cases, office',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPad-pro-case.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 156,
  'post_date' => '2018-10-20 11:49:59',
  'post_date_gmt' => '2018-10-20 11:49:59',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => '27-inch iMac Pro',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => '27-inch-imac-pro',
  'post_modified' => '2018-11-24 11:52:16',
  'post_modified_gmt' => '2018-11-24 11:52:16',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=156',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543060230:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e4a7c6c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"e8b823d\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '157',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iMac.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '2600',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '2600',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'computer, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iMac.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 152,
  'post_date' => '2018-10-20 03:47:35',
  'post_date_gmt' => '2018-10-20 03:47:35',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Proto Smart Watch - Black',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.',
  'post_name' => 'proto-smart-watch-black',
  'post_modified' => '2018-11-24 03:48:46',
  'post_modified_gmt' => '2018-11-24 03:48:46',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=152',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543031305:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"e3a6e4c\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"073c034\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '148',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/smart-watch-black.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '450',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '450',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'smart-watch, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/smart-watch-black.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 159,
  'post_date' => '2018-10-19 13:02:26',
  'post_date_gmt' => '2018-10-19 13:02:26',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Virtual iPhone Music Dock',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.',
  'post_name' => 'virtual-iphone-music-dock',
  'post_modified' => '2018-11-24 13:03:56',
  'post_modified_gmt' => '2018-11-24 13:03:56',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=159',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543064499:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"bc7b6c8\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"b009edd\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '161',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPhone-music-dock.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '250',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '250',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/iPhone-music-dock.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 155,
  'post_date' => '2018-10-19 11:26:40',
  'post_date_gmt' => '2018-10-19 11:26:40',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Retro Style Smart Watch',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => 'retro-style-smart-watch',
  'post_modified' => '2018-11-24 11:36:09',
  'post_modified_gmt' => '2018-11-24 11:36:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=155',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543060055:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"84d092a\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"a1bb500\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '147',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/smart-watch.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '375',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '375',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'smart-watch, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/smart-watch.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 153,
  'post_date' => '2018-10-19 03:50:49',
  'post_date_gmt' => '2018-10-19 03:50:49',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'iMac Pro  2018',
  'post_excerpt' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.',
  'post_name' => 'imac-pro-2018',
  'post_modified' => '2018-11-24 03:52:09',
  'post_modified_gmt' => '2018-11-24 03:52:09',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=153',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543031404:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2d9f309\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"1093892\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '142',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/Apple-mac.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '1400',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '1400',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'computer, technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/Apple-mac.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 162,
  'post_date' => '2018-10-18 13:04:03',
  'post_date_gmt' => '2018-10-18 13:04:03',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit.',
  'post_title' => 'Spyder 2.0 Drone',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'spyder-2-0-drone',
  'post_modified' => '2018-11-24 13:05:07',
  'post_modified_gmt' => '2018-11-24 13:05:07',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?post_type=product&#038;p=162',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_wc_review_count' => '0',
    '_wc_rating_count' => 
    array (
    ),
    '_wc_average_rating' => '0',
    '_edit_lock' => '1543065156:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"28e8e01\\",\\"row_order\\":\\"0\\",\\"cols\\":[{\\"element_id\\":\\"abe9e08\\",\\"column_order\\":\\"0\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_thumbnail_id' => '160',
    'post_image' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/drone.jpg',
    '_wp_old_date' => '2018-11-24',
    '_regular_price' => '600',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_upsell_ids' => 
    array (
    ),
    '_crosssell_ids' => 
    array (
    ),
    '_default_attributes' => 
    array (
    ),
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_product_version' => '3.5.1',
    '_price' => '600',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'technology',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-craft/files/2018/11/drone.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 68,
  'post_date' => '2018-11-22 11:25:56',
  'post_date_gmt' => '2018-11-22 11:25:56',
  'post_content' => '',
  'post_title' => 'Company',
  'post_excerpt' => '',
  'post_name' => 'company',
  'post_modified' => '2018-11-22 11:26:05',
  'post_modified_gmt' => '2018-11-22 11:26:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=68',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '68',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 69,
  'post_date' => '2018-11-22 11:25:56',
  'post_date_gmt' => '2018-11-22 11:25:56',
  'post_content' => '',
  'post_title' => 'Our  Story',
  'post_excerpt' => '',
  'post_name' => 'our-story',
  'post_modified' => '2018-11-22 11:26:05',
  'post_modified_gmt' => '2018-11-22 11:26:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=69',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '69',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 70,
  'post_date' => '2018-11-22 11:25:56',
  'post_date_gmt' => '2018-11-22 11:25:56',
  'post_content' => '',
  'post_title' => 'Locations',
  'post_excerpt' => '',
  'post_name' => 'locations',
  'post_modified' => '2018-11-22 11:26:05',
  'post_modified_gmt' => '2018-11-22 11:26:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=70',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '70',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 71,
  'post_date' => '2018-11-22 11:25:56',
  'post_date_gmt' => '2018-11-22 11:25:56',
  'post_content' => '',
  'post_title' => 'Team',
  'post_excerpt' => '',
  'post_name' => 'team',
  'post_modified' => '2018-11-22 11:26:05',
  'post_modified_gmt' => '2018-11-22 11:26:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=71',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '71',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 72,
  'post_date' => '2018-11-22 11:25:56',
  'post_date_gmt' => '2018-11-22 11:25:56',
  'post_content' => '',
  'post_title' => 'Investors',
  'post_excerpt' => '',
  'post_name' => 'investor',
  'post_modified' => '2018-11-22 11:26:05',
  'post_modified_gmt' => '2018-11-22 11:26:05',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=72',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '72',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'about',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 67,
  'post_date' => '2018-11-22 10:57:31',
  'post_date_gmt' => '2018-11-22 10:57:31',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '67',
  'post_modified' => '2018-11-27 18:35:58',
  'post_modified_gmt' => '2018-11-27 18:35:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=67',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '41',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 205,
  'post_date' => '2018-11-26 03:48:28',
  'post_date_gmt' => '2018-11-26 03:48:28',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '205',
  'post_modified' => '2018-11-27 18:35:58',
  'post_modified_gmt' => '2018-11-27 18:35:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=205',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '4',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 248,
  'post_date' => '2018-11-27 07:26:15',
  'post_date_gmt' => '2018-11-27 07:26:15',
  'post_content' => '',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => '248',
  'post_modified' => '2018-11-27 18:35:58',
  'post_modified_gmt' => '2018-11-27 18:35:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=248',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '212',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 260,
  'post_date' => '2018-11-27 07:48:54',
  'post_date_gmt' => '2018-11-27 07:48:54',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact-2',
  'post_modified' => '2018-11-27 18:35:58',
  'post_modified_gmt' => '2018-11-27 18:35:58',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=260',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '244',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 188,
  'post_date' => '2018-11-26 02:46:45',
  'post_date_gmt' => '2018-11-26 02:46:45',
  'post_content' => '',
  'post_title' => 'Technology',
  'post_excerpt' => '',
  'post_name' => 'technology',
  'post_modified' => '2018-11-26 02:46:45',
  'post_modified_gmt' => '2018-11-26 02:46:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=188',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '188',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/shoppe-craft/product-category/technology/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'product-categories',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 189,
  'post_date' => '2018-11-26 02:46:45',
  'post_date_gmt' => '2018-11-26 02:46:45',
  'post_content' => '',
  'post_title' => 'Office',
  'post_excerpt' => '',
  'post_name' => 'office',
  'post_modified' => '2018-11-26 02:46:45',
  'post_modified_gmt' => '2018-11-26 02:46:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=189',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '189',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/shoppe-craft/product-category/office/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'product-categories',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 190,
  'post_date' => '2018-11-26 02:46:45',
  'post_date_gmt' => '2018-11-26 02:46:45',
  'post_content' => '',
  'post_title' => 'Furniture',
  'post_excerpt' => '',
  'post_name' => 'furniture',
  'post_modified' => '2018-11-26 02:46:45',
  'post_modified_gmt' => '2018-11-26 02:46:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=190',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '190',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/shoppe-craft/product-category/furniture/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'product-categories',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 191,
  'post_date' => '2018-11-26 02:46:45',
  'post_date_gmt' => '2018-11-26 02:46:45',
  'post_content' => '',
  'post_title' => 'Accessories',
  'post_excerpt' => '',
  'post_name' => 'accessories',
  'post_modified' => '2018-11-26 02:46:45',
  'post_modified_gmt' => '2018-11-26 02:46:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=191',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '191',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://themify.me/demo/themes/shoppe-craft/product-category/accessories/',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'product-categories',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 164,
  'post_date' => '2018-11-24 13:18:32',
  'post_date_gmt' => '2018-11-24 13:18:32',
  'post_content' => '',
  'post_title' => 'Twitter',
  'post_excerpt' => '',
  'post_name' => 'twitter',
  'post_modified' => '2018-11-24 13:20:00',
  'post_modified_gmt' => '2018-11-24 13:20:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=164',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '164',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'http://twitter.com/themify',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 165,
  'post_date' => '2018-11-24 13:18:32',
  'post_date_gmt' => '2018-11-24 13:18:32',
  'post_content' => '',
  'post_title' => 'Facebook',
  'post_excerpt' => '',
  'post_name' => 'facebook',
  'post_modified' => '2018-11-24 13:20:00',
  'post_modified_gmt' => '2018-11-24 13:20:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=165',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '165',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'http://facebook.com/themify',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 166,
  'post_date' => '2018-11-24 13:18:32',
  'post_date_gmt' => '2018-11-24 13:18:32',
  'post_content' => '',
  'post_title' => 'Youtube',
  'post_excerpt' => '',
  'post_name' => 'youtube',
  'post_modified' => '2018-11-24 13:20:00',
  'post_modified_gmt' => '2018-11-24 13:20:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=166',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '166',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://www.youtube.com/user/themifyme',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 167,
  'post_date' => '2018-11-24 13:18:32',
  'post_date_gmt' => '2018-11-24 13:18:32',
  'post_content' => '',
  'post_title' => 'Google Plus',
  'post_excerpt' => '',
  'post_name' => 'google-plus',
  'post_modified' => '2018-11-24 13:20:00',
  'post_modified_gmt' => '2018-11-24 13:20:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=167',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '167',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://plus.google.com/109280316400365629341',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 73,
  'post_date' => '2018-11-22 11:27:37',
  'post_date_gmt' => '2018-11-22 11:27:37',
  'post_content' => '',
  'post_title' => 'Order Status',
  'post_excerpt' => '',
  'post_name' => 'order-status',
  'post_modified' => '2018-11-22 11:27:37',
  'post_modified_gmt' => '2018-11-22 11:27:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=73',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '73',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 74,
  'post_date' => '2018-11-22 11:27:37',
  'post_date_gmt' => '2018-11-22 11:27:37',
  'post_content' => '',
  'post_title' => 'Refund Policies',
  'post_excerpt' => '',
  'post_name' => 'refund-policies',
  'post_modified' => '2018-11-22 11:27:37',
  'post_modified_gmt' => '2018-11-22 11:27:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=74',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '74',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 75,
  'post_date' => '2018-11-22 11:27:37',
  'post_date_gmt' => '2018-11-22 11:27:37',
  'post_content' => '',
  'post_title' => 'Complaints',
  'post_excerpt' => '',
  'post_name' => 'complaints',
  'post_modified' => '2018-11-22 11:27:37',
  'post_modified_gmt' => '2018-11-22 11:27:37',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=75',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '75',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 76,
  'post_date' => '2018-11-22 11:27:38',
  'post_date_gmt' => '2018-11-22 11:27:38',
  'post_content' => '',
  'post_title' => 'Help',
  'post_excerpt' => '',
  'post_name' => 'help',
  'post_modified' => '2018-11-22 11:27:38',
  'post_modified_gmt' => '2018-11-22 11:27:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=76',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '76',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 77,
  'post_date' => '2018-11-22 11:27:38',
  'post_date_gmt' => '2018-11-22 11:27:38',
  'post_content' => '',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2018-11-22 11:27:38',
  'post_modified_gmt' => '2018-11-22 11:27:38',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-craft/?p=77',
  'menu_order' => 5,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '77',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => '#',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'support',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_recent-posts" );
$widgets[1002] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-posts", $widgets );

$widgets = get_option( "widget_recent-comments" );
$widgets[1003] = array (
  'title' => '',
  'number' => 5,
);
update_option( "widget_recent-comments", $widgets );

$widgets = get_option( "widget_archives" );
$widgets[1004] = array (
  'title' => '',
  'count' => 0,
  'dropdown' => 0,
);
update_option( "widget_archives", $widgets );

$widgets = get_option( "widget_categories" );
$widgets[1005] = array (
  'title' => '',
  'count' => 0,
  'hierarchical' => 0,
  'dropdown' => 0,
);
update_option( "widget_categories", $widgets );

$widgets = get_option( "widget_meta" );
$widgets[1006] = array (
  'title' => '',
);
update_option( "widget_meta", $widgets );

$widgets = get_option( "widget_text" );
$widgets[1007] = array (
  'title' => '',
  'text' => 'Shoppe Craft is a powerful shop theme created by Themify. It’s powered by WooCommerce and is highly customizable.',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1008] = array (
  'title' => 'Categories',
  'nav_menu' => themify_import_get_term_id_from_slug( "product-categories" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1009] = array (
  'title' => 'About',
  'nav_menu' => themify_import_get_term_id_from_slug( "about" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1010] = array (
  'title' => 'Support',
  'nav_menu' => themify_import_get_term_id_from_slug( "support" ),
);
update_option( "widget_nav_menu", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1011] = array (
  'title' => 'Social',
  'nav_menu' => themify_import_get_term_id_from_slug( "social" ),
);
update_option( "widget_nav_menu", $widgets );



$sidebars_widgets = array (
  'sidebar-main' => 
  array (
    0 => 'recent-posts-1002',
    1 => 'recent-comments-1003',
    2 => 'archives-1004',
    3 => 'categories-1005',
    4 => 'meta-1006',
  ),
  'below-logo-widget' => 
  array (
    0 => 'text-1007',
  ),
  'footer-widget-1' => 
  array (
    0 => 'nav_menu-1008',
  ),
  'footer-widget-2' => 
  array (
    0 => 'nav_menu-1009',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1010',
  ),
  'footer-widget-4' => 
  array (
    0 => 'nav_menu-1011',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:91:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:12:"sidebar-none";s:27:"setting-default_post_layout";s:5:"grid4";s:20:"setting-post_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:12:"sidebar-none";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:28:"setting-search-result_layout";s:8:"sidebar1";s:33:"setting-search-result_post_layout";s:9:"list-post";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:12:"sidebar-none";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:16:"header-logo-left";s:21:"setting-footer_design";s:18:"footer-left-column";s:22:"setting-use_float_back";s:2:"on";s:22:"setting-footer_widgets";s:17:"footerwidget-4col";s:30:"setting-footer_widget_position";s:3:"top";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:27:"setting-product_post_gutter";s:6:"gutter";s:23:"setting-products_slider";s:7:"disable";s:30:"setting-shop_products_per_page";s:1:"8";s:46:"setting-default_product_index_image_post_width";s:3:"300";s:47:"setting-default_product_index_image_post_height";s:3:"331";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:47:"setting-default_product_single_image_post_width";s:3:"660";s:30:"setting-related_products_limit";s:1:"3";s:21:"setting-wishlist_page";s:3:"195";s:18:"setting-cart_style";s:8:"dropdown";s:25:"setting-cart_show_seconds";s:4:"1000";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:107:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:108:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"Google+";s:31:"setting-link_img_themify-link-2";s:111:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/themify/img/social/google-plus.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:7:"YouTube";s:31:"setting-link_img_themify-link-3";s:107:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-4";s:10:"image-icon";s:33:"setting-link_title_themify-link-4";s:9:"Pinterest";s:31:"setting-link_img_themify-link-4";s:109:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:7:"Twitter";s:33:"setting-link_ficon_themify-link-5";s:10:"fa-twitter";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:8:"Facebook";s:33:"setting-link_ficon_themify-link-6";s:11:"fa-facebook";s:32:"setting-link_type_themify-link-7";s:9:"font-icon";s:33:"setting-link_title_themify-link-7";s:7:"Google+";s:33:"setting-link_ficon_themify-link-7";s:14:"fa-google-plus";s:32:"setting-link_type_themify-link-8";s:9:"font-icon";s:33:"setting-link_title_themify-link-8";s:7:"YouTube";s:33:"setting-link_ficon_themify-link-8";s:10:"fa-youtube";s:32:"setting-link_type_themify-link-9";s:9:"font-icon";s:33:"setting-link_title_themify-link-9";s:9:"Pinterest";s:33:"setting-link_ficon_themify-link-9";s:12:"fa-pinterest";s:22:"setting-link_field_ids";s:341:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5","themify-link-6":"themify-link-6","themify-link-7":"themify-link-7","themify-link-8":"themify-link-8","themify-link-9":"themify-link-9"}";s:23:"setting-link_field_hash";s:2:"10";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:98:"https://themify.me/demo/themes/shoppe-craft/wp-content/themes/themify-shoppe/skins/craft/style.css";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();