<?php

defined( 'ABSPATH' ) or die;

$GLOBALS['processed_terms'] = array();
$GLOBALS['processed_posts'] = array();

require_once ABSPATH . 'wp-admin/includes/post.php';
require_once ABSPATH . 'wp-admin/includes/taxonomy.php';
require_once ABSPATH . 'wp-admin/includes/image.php';

/**
 * Add an Import Action, this data is stored for processing after import is done.
 *
 * Each action is sent as an Ajax request and is handled by themify-ajax.php file
 */ 
function themify_add_import_action( $action = '', $data = array() ) {
	global $import_actions;

	if ( ! isset( $import_actions[ $action ] ) ) {
		$import_actions[ $action ] = array();
	}

	$import_actions[ $action ][] = $data;
}

function themify_import_post( $post ) {
	global $processed_posts, $processed_terms;

	if ( ! post_type_exists( $post['post_type'] ) ) {
		return;
	}

	/* Menu items don't have reliable post_title, skip the post_exists check */
	if( $post['post_type'] !== 'nav_menu_item' ) {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
		if ( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
			$processed_posts[ intval( $post['ID'] ) ] = intval( $post_exists );
			return;
		}
	}

	if( $post['post_type'] == 'nav_menu_item' ) {
		if( ! isset( $post['tax_input']['nav_menu'] ) || ! term_exists( $post['tax_input']['nav_menu'], 'nav_menu' ) ) {
			return;
		}
		$_menu_item_type = $post['meta_input']['_menu_item_type'];
		$_menu_item_object_id = $post['meta_input']['_menu_item_object_id'];

		if ( 'taxonomy' == $_menu_item_type && isset( $processed_terms[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_terms[ intval( $_menu_item_object_id ) ];
		} else if ( 'post_type' == $_menu_item_type && isset( $processed_posts[ intval( $_menu_item_object_id ) ] ) ) {
			$post['meta_input']['_menu_item_object_id'] = $processed_posts[ intval( $_menu_item_object_id ) ];
		} else if ( 'custom' != $_menu_item_type ) {
			// associated object is missing or not imported yet, we'll retry later
			// $missing_menu_items[] = $item;
			return;
		}
	}

	$post_parent = ( $post['post_type'] == 'nav_menu_item' ) ? $post['meta_input']['_menu_item_menu_item_parent'] : (int) $post['post_parent'];
	$post['post_parent'] = 0;
	if ( $post_parent ) {
		// if we already know the parent, map it to the new local ID
		if ( isset( $processed_posts[ $post_parent ] ) ) {
			if( $post['post_type'] == 'nav_menu_item' ) {
				$post['meta_input']['_menu_item_menu_item_parent'] = $processed_posts[ $post_parent ];
			} else {
				$post['post_parent'] = $processed_posts[ $post_parent ];
			}
		}
	}

	/**
	 * for hierarchical taxonomies, IDs must be used so wp_set_post_terms can function properly
	 * convert term slugs to IDs for hierarchical taxonomies
	 */
	if( ! empty( $post['tax_input'] ) ) {
		foreach( $post['tax_input'] as $tax => $terms ) {
			if( is_taxonomy_hierarchical( $tax ) ) {
				$terms = explode( ', ', $terms );
				$post['tax_input'][ $tax ] = array_map( 'themify_get_term_id_by_slug', $terms, array_fill( 0, count( $terms ), $tax ) );
			}
		}
	}

	$post['post_author'] = (int) get_current_user_id();
	$post['post_status'] = 'publish';

	$old_id = $post['ID'];

	unset( $post['ID'] );
	$post_id = wp_insert_post( $post, true );
	if( is_wp_error( $post_id ) ) {
		return false;
	} else {
		$processed_posts[ $old_id ] = $post_id;

		return $post_id;
	}
}

function themify_get_placeholder_image() {
	static $placeholder_image = null;

	if( $placeholder_image == null ) {
		if ( ! function_exists( 'WP_Filesystem' ) ) {
			require_once ABSPATH . 'wp-admin/includes/file.php';
		}
		WP_Filesystem();
		global $wp_filesystem;
		$upload = wp_upload_bits( $post['post_name'] . '.jpg', null, $wp_filesystem->get_contents( THEMIFY_DIR . '/img/image-placeholder.jpg' ) );

		if ( $info = wp_check_filetype( $upload['file'] ) )
			$post['post_mime_type'] = $info['type'];
		else
			return new WP_Error( 'attachment_processing_error', __( 'Invalid file type', 'themify' ) );

		$post['guid'] = $upload['url'];
		$post_id = wp_insert_attachment( $post, $upload['file'] );
		wp_update_attachment_metadata( $post_id, wp_generate_attachment_metadata( $post_id, $upload['file'] ) );

		$placeholder_image = $post_id;
	}

	return $placeholder_image;
}

function themify_import_term( $term ) {
	global $processed_terms;

	if( $term_id = term_exists( $term['slug'], $term['taxonomy'] ) ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];
		if ( isset( $term['term_id'] ) )
			$processed_terms[ intval( $term['term_id'] ) ] = (int) $term_id;
		return (int) $term_id;
	}

	if ( empty( $term['parent'] ) ) {
		$parent = 0;
	} else {
		$parent = term_exists( $processed_terms[ intval( $term['parent'] ) ], $term['taxonomy'] );
		if ( is_array( $parent ) ) $parent = $parent['term_id'];
	}

	$id = wp_insert_term( $term['name'], $term['taxonomy'], array(
		'parent' => $parent,
		'slug' => $term['slug'],
		'description' => $term['description'],
	) );
	if ( ! is_wp_error( $id ) ) {
		if ( isset( $term['term_id'] ) ) {
			// success!
			$processed_terms[ intval($term['term_id']) ] = $id['term_id'];
			if ( isset( $term['thumbnail'] ) ) {
				themify_add_import_action( 'term_thumb', array(
					'id' => $id['term_id'],
					'thumb' => $term['thumbnail'],
				) );
			}
			return $term['term_id'];
		}
	}

	return false;
}

function themify_get_term_id_by_slug( $slug, $tax ) {
	$term = get_term_by( 'slug', $slug, $tax );
	if( $term ) {
		return $term->term_id;
	}

	return false;
}

function themify_undo_import_term( $term ) {
	$term_id = term_exists( $term['slug'], $term['taxonomy'] );
	if ( $term_id ) {
		if ( is_array( $term_id ) ) $term_id = $term_id['term_id'];

		if ( $term_thumbnail = get_term_meta( $term['term_id'], 'thumbnail_id', true ) ) {
			wp_delete_attachment( $term_thumbnail, true );
		}

		if ( isset( $term_id ) ) {
			wp_delete_term( $term_id, $term['taxonomy'] );
		}
	}
}

/**
 * Determine if a post exists based on title, content, and date
 *
 * @global wpdb $wpdb WordPress database abstraction object.
 *
 * @param array $args array of database parameters to check
 * @return int Post ID if post exists, 0 otherwise.
 */
function themify_post_exists( $args = array() ) {
	global $wpdb;

	$query = "SELECT ID FROM $wpdb->posts WHERE 1=1";
	$db_args = array();

	foreach ( $args as $key => $value ) {
		$value = wp_unslash( sanitize_post_field( $key, $value, 0, 'db' ) );
		if( ! empty( $value ) ) {
			$query .= ' AND ' . $key . ' = %s';
			$db_args[] = $value;
		}
	}

	if ( !empty ( $args ) )
		return (int) $wpdb->get_var( $wpdb->prepare($query, $args) );

	return 0;
}

function themify_undo_import_post( $post ) {
	if( $post['post_type'] == 'nav_menu_item' ) {
		$post_exists = themify_post_exists( array(
			'post_name' => $post['post_name'],
			'post_modified' => $post['post_date'],
			'post_type' => 'nav_menu_item',
		) );
	} else {
		$post_exists = post_exists( $post['post_title'], '', $post['post_date'] );
	}
	if( $post_exists && get_post_type( $post_exists ) == $post['post_type'] ) {
		/**
		 * check if the post has been modified, if so leave it be
		 *
		 * NOTE: posts are imported using wp_insert_post() which modifies post_modified field
		 * to be the same as post_date, hence to check if the post has been modified,
		 * the post_modified field is compared against post_date in the original post.
		 */
		if( $post['post_date'] == get_post_field( 'post_modified', $post_exists ) ) {
			// find and remove all post attachments
			$attachments = get_posts( array(
				'post_type' => 'attachment',
				'posts_per_page' => -1,
				'post_parent' => $post_exists,
			) );
			if ( $attachments ) {
				foreach ( $attachments as $attachment ) {
					wp_delete_attachment( $attachment->ID, true );
				}
			}
			wp_delete_post( $post_exists, true ); // true: bypass trash
		}
	}
}

function themify_process_post_import( $post ) {
	if( ERASEDEMO ) {
		themify_undo_import_post( $post );
	} else {
		if ( $id = themify_import_post( $post ) ) {
			if ( defined( 'IMPORT_IMAGES' ) && ! IMPORT_IMAGES ) {
				/* if importing images is disabled and post is supposed to have a thumbnail, create a placeholder image instead */
				if ( isset( $post['thumb'] ) ) { // the post is supposed to have featured image
					$placeholder = themify_get_placeholder_image();
					if( ! is_wp_error( $placeholder ) ) {
						set_post_thumbnail( $id, $placeholder );
					}
				}
			} else {
				if ( isset( $post["thumb"] ) ) {
					themify_add_import_action( 'post_thumb', array(
						'id' => $id,
						'thumb' => $post["thumb"],
					) );
				}
				if ( isset( $post["gallery_shortcode"] ) ) {
					themify_add_import_action( 'gallery_field', array(
						'id' => $id,
						'fields' => $post["gallery_shortcode"],
					) );
				}
				if ( isset( $post["_product_image_gallery"] ) ) {
					themify_add_import_action( 'product_gallery', array(
						'id' => $id,
						'images' => $post["_product_image_gallery"],
					) );
				}
			}
		}
	}
}
$thumbs = array();
function themify_do_demo_import() {
global $import_actions;

	if ( isset( $GLOBALS["ThemifyBuilder_Data_Manager"] ) ) {
		remove_action( "save_post", array( $GLOBALS["ThemifyBuilder_Data_Manager"], "save_builder_text_only"), 10, 3 );
	}
$term = array (
  'term_id' => 19,
  'name' => 'Women',
  'slug' => 'women',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 20,
  'name' => 'Accessories',
  'slug' => 'accessories',
  'term_group' => 0,
  'taxonomy' => 'product_cat',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 16,
  'name' => 'Main Navigation',
  'slug' => 'main-navigation',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$term = array (
  'term_id' => 21,
  'name' => 'Social Icon',
  'slug' => 'social-icon',
  'term_group' => 0,
  'taxonomy' => 'nav_menu',
  'description' => '',
  'parent' => 0,
);

if( ERASEDEMO ) {
	themify_undo_import_term( $term );
} else {
	themify_import_term( $term );
}

$post = array (
  'ID' => 10,
  'post_date' => '2019-08-09 02:14:25',
  'post_date_gmt' => '2019-08-09 02:14:25',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h4>About our</h4> <h1>Company</h1>
<p>We are dedicated to providing the ultimate one-stop fashion destination for all shoppers. From major fashion house designs to the latest streetwear brands, we’ve got a little something for everyone.</p>
<h3>Our Story</h3>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-story-720x532.jpg" width="720" alt="our-story" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-story-720x532.jpg 720w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-story-600x444.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-story.jpg 767w" sizes="(max-width: 720px) 100vw, 720px" />
<p>What started out as a joint venture between two best friends in 2010 has grown to one of the largest eCommerce stores with a cult following. Great news, the two founders are still best friends and co-CEOs, and they\'re still crazy about fashion.</p>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-company-720x572.jpg" width="720" alt="our-company" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-company.jpg 720w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/our-company-600x477.jpg 600w" sizes="(max-width: 720px) 100vw, 720px" />
<h3>Our Team</h3>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/09/stephanie-moore-308x392.jpg" width="308" title="Nadya Catherine" alt="Co-CEO" /> <h3> Nadya Catherine </h3> Co-CEO
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/stephanie-moore-308x392.jpg" width="308" title="Stephanie Moore" alt="Co-CEO" /> <h3> Stephanie Moore </h3> Co-CEO
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/rebbeca-chan-308x392.jpg" width="308" title="Rebecca Lim" alt="Director of Design" /> <h3> Rebecca Lim </h3> Director of Design
<a href="https://www.instagram.com/themify/"> </a> <a href="http://twitter.com/themify"> </a> <a href="https://www.linkedin.com/company/themify/about/"> </a>
<h3>Locations</h3>
<h3>Los Angeles</h3> <p>777 Bohemia Drive<br />Los Angeles, 90210</p> <p>M - F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0888</p>
<a href="https://themify.me/" > Get Directions </a>
<h3>New York</h3> <p>88 9th Street<br />Manhattan, 10003</p> <p>M - F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0777</p>
<a href="https://themify.me/" > Get Directions </a>
<h3>Miami</h3> <p>4325 Miami Avenue<br />Miami, 33136</p> <p>M - F: 11am – 8pm <br />Sat: 10am – 8pm <br />Sun: 12pm – 5pm<br />Phone: 416-597-0999</p>
<a href="https://themify.me/" > Get Directions </a>
<link id="themify-builder-427-generated" rel="stylesheet" href="https://themify.me/demo/themes/shoppe-fashion/files/themify-css/themify-builder-427-generated.css?ver=1567193118" type="text/css" /> 
 <h3>Exclusive Discounts</h3> <p>Subscribe to our newsletter for a 15% discount!</p> 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'About',
  'post_excerpt' => '',
  'post_name' => 'about',
  'post_modified' => '2019-09-02 21:55:42',
  'post_modified_gmt' => '2019-09-02 21:55:42',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?page_id=10',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"xko4183\\",\\"cols\\":[{\\"element_id\\":\\"hzb3184\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"l9d023\\",\\"mod_settings\\":{\\"content_text\\":\\"<h4>About our<\\\\/h4>\\\\n<h1>Company<\\\\/h1>\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"margin_bottom\\":\\"40\\",\\"breakpoint_mobile\\":{\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"36\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h4_unit\\":\\"px\\",\\"font_size_h4\\":\\"22\\",\\"font_color_type_h4\\":\\"font_color_h4_solid\\"},\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"40\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"line_height_h1_unit\\":\\"em\\",\\"line_height_h1\\":\\"0.8\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"60\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}}},{\\"element_id\\":\\"jes1740\\",\\"cols\\":[{\\"element_id\\":\\"3k1w747\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"bhsc724\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>We are dedicated to providing the ultimate one-stop fashion destination for all shoppers. From major fashion house designs to the latest streetwear brands, we’ve got a little something for everyone.<\\\\/p>\\",\\"padding_right\\":\\"16\\",\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_top\\":\\"57\\",\\"breakpoint_mobile\\":{\\"margin_bottom\\":\\"0\\",\\"margin_bottom_unit\\":\\"%\\"},\\"padding_right_unit\\":\\"%\\",\\"breakpoint_tablet\\":{\\"margin_bottom\\":\\"1\\",\\"margin_bottom_unit\\":\\"%\\"},\\"padding_left_unit\\":\\"%\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"9sv8866\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Story<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"40\\",\\"margin_top\\":\\"40\\",\\"breakpoint_mobile\\":{\\"margin_top\\":\\"0\\",\\"margin_bottom\\":\\"24\\",\\"margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"margin_top\\":\\"0\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"tvte671\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/our-story-720x532.jpg\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"720\\",\\"margin_left\\":\\"-40\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"down\\"}}},\\"auto_fullwidth\\":\\"1\\",\\"breakpoint_tablet\\":{\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"0\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_left\\":\\"0\\"}}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zu0m917\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>What started out as a joint venture between two best friends in 2010 has grown to one of the largest eCommerce stores with a cult following. Great news, the two founders are still best friends and co-CEOs, and they\\\\\\\\\\\'re still crazy about fashion.<\\\\/p>\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"background_color\\":\\"#ffffff\\",\\"font_color\\":\\"#000000\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-40\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"-70\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"70\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\",\\"margin_right\\":\\"0\\",\\"margin_top\\":\\"0\\"},\\"breakpoint_tablet\\":{\\"margin_left\\":\\"0\\",\\"margin_left_unit\\":\\"%\\",\\"margin_right_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_right\\":\\"-70\\",\\"margin_top\\":\\"0\\",\\"padding_right\\":\\"6\\",\\"padding_right_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_left\\":\\"6\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\"},\\"b_sh_color\\":\\"#000000_0.12\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"3\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\"}}],\\"styling\\":{\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}],\\"styling\\":{\\"background_color\\":\\"#ddbc6a\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"font_color\\":\\"#ffffff\\",\\"padding_bottom\\":\\"50\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"0\\"},\\"background_type\\":\\"image\\",\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"0\\"}}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"padding_top\\":\\"14\\",\\"padding_top_unit\\":\\"px\\"}}},{\\"element_id\\":\\"15vz279\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"55wt88\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"auto_fullwidth\\":\\"1\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/our-company.jpg\\",\\"style_image\\":\\"image-center\\",\\"width_image\\":\\"720\\",\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"margin_left\\":\\"-60\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"30\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"0,22\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"down\\"}}},\\"breakpoint_tablet\\":{\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"40\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_left\\":\\"0\\"}}}]}],\\"gutter\\":\\"gutter-none\\",\\"tablet_dir\\":\\"rtl\\",\\"mobile_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column-full\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"0\\",\\"margin-top\\":\\"0\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"14\\"},\\"breakpoint_tablet\\":{\\"margin-top\\":\\"0\\",\\"margin-top_unit\\":\\"px\\",\\"padding_top\\":\\"8\\",\\"padding_bottom\\":\\"0\\",\\"padding_top_unit\\":\\"%\\"},\\"padding_top\\":\\"78\\",\\"padding_top_unit\\":\\"px\\",\\"breakpoint_tablet_landscape\\":{\\"margin-top\\":\\"0\\",\\"margin-top_unit\\":\\"px\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"25\\"}}},{\\"element_id\\":\\"sg7n229\\",\\"cols\\":[{\\"element_id\\":\\"24xn229\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"c1vg35\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Team<\\\\/h3>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"element_id\\":\\"6g6e380\\",\\"cols\\":[{\\"element_id\\":\\"n4fk381\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"h15f381\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/09\\\\/stephanie-moore.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Nadya Catherine\\",\\"global_styles\\":\\"tb_gs4245d6\\",\\"caption_image\\":\\"Co-CEO\\",\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"nyn1381\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"0yvd382\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"zy2z382\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/stephanie-moore-308x392.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Stephanie Moore\\",\\"global_styles\\":\\"tb_gs4245d6\\",\\"caption_image\\":\\"Co-CEO\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"982e382\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"hnex382\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cub3382\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/rebbeca-chan-308x392.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Rebecca Lim\\",\\"global_styles\\":\\"tb_gs4245d6\\",\\"caption_image\\":\\"Director of Design\\"}},{\\"mod_name\\":\\"icon\\",\\"element_id\\":\\"1jux383\\",\\"mod_settings\\":{\\"content_icon\\":[{\\"icon\\":\\"ti-instagram\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.instagram.com\\\\/themify\\\\/\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-twitter-alt\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"http:\\\\/\\\\/twitter.com\\\\/themify\\",\\"link_options\\":\\"regular\\"},{\\"icon\\":\\"ti-linkedin\\",\\"icon_color_bg\\":\\"transparent\\",\\"link\\":\\"https:\\\\/\\\\/www.linkedin.com\\\\/company\\\\/themify\\\\/about\\\\/\\",\\"link_options\\":\\"regular\\"}],\\"icon_position\\":\\"icon_position_center\\",\\"icon_arrangement\\":\\"icon_horizontal\\",\\"icon_style\\":\\"circle\\",\\"icon_size\\":\\"large\\",\\"font_color_icon_hover\\":\\"#ddbc6a\\",\\"font_color_icon\\":\\"#999999\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\"},\\"breakpoint_tablet\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\"}}}],\\"col_tablet\\":\\"column-full\\"}]}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"breakpoint_mobile\\":{\\"padding_bottom\\":\\"5\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"3\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top\\":\\"3\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"011k395\\",\\"cols\\":[{\\"element_id\\":\\"k2v2397\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6hjs367\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Locations<\\\\/h3>\\",\\"h3_margin_bottom_unit\\":\\"px\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"55\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"breakpoint_mobile\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"h3_margin_bottom_unit\\":\\"px\\",\\"h3_margin_bottom\\":\\"40\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"50\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"element_id\\":\\"kbry664\\",\\"cols\\":[{\\"element_id\\":\\"vjfp665\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"4nkg680\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Los Angeles<\\\\/h3>\\\\n<p>777 Bohemia Drive<br \\\\/>Los Angeles, 90210<\\\\/p>\\\\n<p>M - F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0888<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8n7x695\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\"}}},{\\"element_id\\":\\"wzfu666\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"zfxj254\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>New York<\\\\/h3>\\\\n<p>88 9th Street<br \\\\/>Manhattan, 10003<\\\\/p>\\\\n<p>M - F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0777<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"j2ha32\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\"}}},{\\"element_id\\":\\"p99r666\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"df5r329\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Miami<\\\\/h3>\\\\n<p>4325 Miami Avenue<br \\\\/>Miami, 33136<\\\\/p>\\\\n<p>M - F: 11am – 8pm <br \\\\/>Sat: 10am – 8pm <br \\\\/>Sun: 12pm – 5pm<br \\\\/>Phone: 416-597-0999<\\\\/p>\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"20\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"28\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"rz0b850\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Get Directions\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"alignment\\":\\"center\\",\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"30\\"}}}]}]}],\\"styling\\":{\\"background_color\\":\\"f7f5f7\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"5\\",\\"breakpoint_tablet\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_top\\":\\"7\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_top\\":\\"6\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_opp_top\\":\\"1\\"}}},{\\"element_id\\":\\"6a1k686\\",\\"cols\\":[{\\"element_id\\":\\"309t687\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"e8rw688\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 16,
  'post_date' => '2019-08-09 02:15:17',
  'post_date_gmt' => '2019-08-09 02:15:17',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Blog',
  'post_excerpt' => '',
  'post_name' => 'blog',
  'post_modified' => '2019-08-09 02:15:18',
  'post_modified_gmt' => '2019-08-09 02:15:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?page_id=16',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 21,
  'post_date' => '2019-08-09 02:16:54',
  'post_date_gmt' => '2019-08-09 02:16:54',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_cart]<!-- /wp:shortcode -->',
  'post_title' => 'Cart',
  'post_excerpt' => '',
  'post_name' => 'cart',
  'post_modified' => '2019-08-09 02:16:54',
  'post_modified_gmt' => '2019-08-09 02:16:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/cart/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 22,
  'post_date' => '2019-08-09 02:16:54',
  'post_date_gmt' => '2019-08-09 02:16:54',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_checkout]<!-- /wp:shortcode -->',
  'post_title' => 'Checkout',
  'post_excerpt' => '',
  'post_name' => 'checkout',
  'post_modified' => '2019-08-09 02:16:54',
  'post_modified_gmt' => '2019-08-09 02:16:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/checkout/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 13,
  'post_date' => '2019-08-09 02:14:45',
  'post_date_gmt' => '2019-08-09 02:14:45',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>Contact</h1>
<p>Please check our FAQ page for any shipping, returns, policy related issues.</p> <p>If there\'s anything else you need, we’d love to hear from you! </p>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-486x536.jpg" width="486" alt="white-dress-lace" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-486x536.jpg 486w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-768x847.jpg 768w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace-1530x1688.jpg 1530w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace.jpg 1200w" sizes="(max-width: 486px) 100vw, 486px" />
<form action="https://themify.me/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php" id="contact-0--form" method="post"> <label for="contact-0--contact-name">Name *</label> <input type="text" name="contact-name" placeholder="" id="contact-0--contact-name" value="" required/> <label for="contact-0--contact-email">Email *</label> <input type="text" name="contact-email" placeholder="" id="contact-0--contact-email" value="" required /> <label for="contact-0--contact-subject">Subject *</label> <input type="text" name="contact-subject" placeholder="" id="contact-0--contact-subject" value="" required /> <label for="contact-0--contact-message">Message *</label> <textarea name="contact-message" placeholder="" id="contact-0--contact-message" rows="8" cols="45" required></textarea> <button type="submit"> Send </button> </form>
<link id="themify-builder-427-generated" rel="stylesheet" href="https://themify.me/demo/themes/shoppe-fashion/files/themify-css/themify-builder-427-generated.css?ver=1567193118" type="text/css" /> 
 <h3>Exclusive Discounts</h3> <p>Subscribe to our newsletter for a 15% discount!</p> 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'Contact',
  'post_excerpt' => '',
  'post_name' => 'contact',
  'post_modified' => '2019-09-02 22:01:04',
  'post_modified_gmt' => '2019-09-02 22:01:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?page_id=13',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5p6v993\\",\\"cols\\":[{\\"element_id\\":\\"ermn993\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"84u6998\\",\\"cols\\":[{\\"element_id\\":\\"0lp20\\",\\"grid_class\\":\\"col4-1\\"},{\\"element_id\\":\\"xah60\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"if70956\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Contact<\\\\/h1>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_mobile\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"45\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_left\\":\\"35\\",\\"text_align\\":\\"left\\"},\\"breakpoint_tablet\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"50\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_left\\":\\"40\\"},\\"breakpoint_tablet_landscape\\":{\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"50\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"65\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"}},{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mhqv695\\",\\"mod_settings\\":{\\"content_text\\":\\"<p>Please check our FAQ page for any shipping, returns, policy related issues.<\\\\/p>\\\\n<p>If there\\\\\\\\\\\'s anything else you need, we’d love to hear from you! <\\\\/p>\\",\\"text_align\\":\\"right\\",\\"font_color_type\\":\\"font_color_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"margin_left\\":\\"40\\",\\"breakpoint_mobile\\":{\\"margin_left\\":\\"40\\",\\"margin_bottom\\":\\"20\\"},\\"margin_bottom\\":\\"12\\",\\"margin_bottom_unit\\":\\"%\\",\\"breakpoint_tablet\\":{\\"margin_left\\":\\"40\\",\\"margin_bottom\\":\\"50\\"},\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.2\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"text_align\\":\\"left\\"},\\"breakpoint_tablet_landscape\\":{\\"margin-top\\":\\"0\\"}}}],\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column-full\\"}],\\"styling\\":{\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"5\\"}},{\\"element_id\\":\\"3di2102\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"4xf7611\\",\\"cols\\":[{\\"element_id\\":\\"klkj613\\",\\"grid_class\\":\\"col4-3\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"diw8244\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"486\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/white-dress-lace-486x536.jpg\\",\\"style_image\\":\\"image-top\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"-10\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"10\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"custom_parallax_scroll_speed\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"10\\",\\"margin_top\\":\\"5\\",\\"checkbox_margin_apply_all\\":\\"1\\"},\\"breakpoint_tablet\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_top_unit\\":\\"%\\",\\"margin_left\\":\\"5\\",\\"margin_bottom\\":\\"5\\",\\"margin_top\\":\\"-5\\"},\\"image_zoom_icon\\":\\"\\",\\"auto_fullwidth\\":\\"\\",\\"appearance_image\\":\\"\\",\\"caption_on_overlay\\":\\"\\"}}]},{\\"element_id\\":\\"ug54614\\",\\"grid_class\\":\\"col4-1\\"}],\\"gutter\\":\\"gutter-none\\",\\"col_tablet_landscape\\":\\"column-full\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"background_color\\":\\"ddbc6a\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"padding_top\\":\\"9\\",\\"padding_top_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"padding_top\\":\\"31\\",\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_tablet\\":{\\"padding_top\\":\\"13\\",\\"padding_top_unit\\":\\"%\\"},\\"breakpoint_tablet_landscape\\":{\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"32\\"}}},{\\"element_id\\":\\"svh9673\\",\\"cols\\":[{\\"element_id\\":\\"dpoa675\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"contact\\",\\"element_id\\":\\"l5jp26\\",\\"mod_settings\\":{\\"field_name_label\\":\\"Name\\",\\"field_email_label\\":\\"Email\\",\\"field_subject_label\\":\\"Subject\\",\\"field_message_label\\":\\"Message\\",\\"field_sendcopy_label\\":\\"Send a copy to myself\\",\\"field_send_label\\":\\"Send\\",\\"gdpr_label\\":\\"I consent to my submitted data being collected and stored\\",\\"field_name_require\\":\\"yes\\",\\"field_email_require\\":\\"yes\\",\\"field_name_active\\":\\"yes\\",\\"field_email_active\\":\\"yes\\",\\"field_subject_active\\":\\"yes\\",\\"field_subject_require\\":\\"yes\\",\\"field_message_active\\":\\"yes\\",\\"field_send_align\\":\\"center\\",\\"field_extra\\":\\"{ \\\\\\\\\\\\\\"fields\\\\\\\\\\\\\\": [] }\\",\\"field_order\\":\\"{}\\",\\"contact_sent_from\\":\\"enable\\",\\"layout_contact\\":\\"style2\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"background_color\\":\\"f7f5f7\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"breakpoint_mobile\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"9\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top\\":\\"9\\"},\\"breakpoint_tablet\\":{\\"padding_bottom\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"padding_top_unit\\":\\"%\\"}}},{\\"element_id\\":\\"29bj828\\",\\"cols\\":[{\\"element_id\\":\\"oh1k828\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"8ywc974\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 7,
  'post_date' => '2019-08-09 02:14:02',
  'post_date_gmt' => '2019-08-09 02:14:02',
  'post_content' => '<!-- wp:themify-builder/canvas /--><!--themify_builder_static--><h1>The September Issue</h1> <p>Our latest drop, featuring collaborations with three fashion houses, is exclusively available online now.</p>
<a href="https://themify.me/" > Shop Now </a>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/hero-banner-top-770x522.jpg" width="770" alt="hero-banner-top" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/hero-banner-top.jpg 770w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/hero-banner-top-600x407.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/hero-banner-top-768x521.jpg 768w" sizes="(max-width: 770px) 100vw, 770px" />
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag-310x342.jpg" width="310" alt="woman-bag" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag-310x342.jpg 310w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag-768x847.jpg 768w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-bag.jpg 1200w" sizes="(max-width: 310px) 100vw, 310px" />
<h3>Shop Bags</h3>
<a href="https://themify.me/" > View more </a>

<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress-310x342.jpg" width="310" alt="woman-dress" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress-310x342.jpg 310w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress-768x847.jpg 768w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-dress.jpg 1200w" sizes="(max-width: 310px) 100vw, 310px" />
<h3>Shop Dresses</h3>
<a href="https://themify.me/" > View more </a>

<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1-310x342.jpg" width="310" alt="sunglasses" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1-310x342.jpg 310w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1-544x600.jpg 544w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1-768x847.jpg 768w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1-600x662.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sunglasses-1.jpg 1200w" sizes="(max-width: 310px) 100vw, 310px" />
<h3>Shop Accessories</h3>
<a href="https://themify.me/" > View more </a>

<h3>What\'s New?</h3>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/fashion-bag-image-600x479.jpg" width="600" alt="fashion-bag-image" />
<h3>Fall Bag Essentials</h3> <p>We\'ve got a full selection of the latest styles for handbags, crossbodies, satchels, totes, and more!</p>
<a href="https://themify.me/" > Shop Now </a>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/fashion-jacket-image-600x662.jpg" width="600" alt="fashion-jacket-image" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/fashion-jacket-image.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/fashion-jacket-image-544x600.jpg 544w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>Coat Season is Upon Us</h3> <p>There\'s nothing better than bundling up in an elegant jacket with the air crisp and bright.</p>
<a href="https://themify.me/" > Shop Now </a>
<img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/red-earring-girl-600x641.jpg" width="600" alt="red-earring-girl" srcset="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/red-earring-girl-600x641.jpg 600w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/red-earring-girl-561x600.jpg 561w, https://themify.me/demo/themes/shoppe-fashion/files/2019/08/red-earring-girl.jpg 580w" sizes="(max-width: 600px) 100vw, 600px" />
<h3>Show Stopper Earrings</h3> <p>Glamorous or minimal - our collection of drop dead gorgeous earrings are worth the look.</p>
<a href="https://themify.me/" > Shop Now </a>
<h3>Our Top Sellers</h3>
<ul data-width="262" data-height="287">
 <li data-product-id="315"> <figure ><a href="https://themify.me/demo/themes/shoppe-fashion/product/bardot-longsleeve/"><img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/womoan-hat-262x287.jpg" width="262" height="287" alt="womoan-hat" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-fashion/product/bardot-longsleeve/"> <h3>Bardot Longsleeve</h3> &#36;125.00 </a> Rated <strong>0</strong> out of 5 <a href="/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php?add-to-cart=315" data-quantity="1" data-product_id="315" data-product_sku="" aria-label="Add &ldquo;Bardot Longsleeve&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-fashion/wp-admin/post.php?post=315&#038;action=edit">Edit</a>] <a data-id="315" onclick="javascript:void(0)" href="#" rel="nofollow"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-fashion/files/woocommerce-placeholder.png" href="https://themify.me/demo/themes/shoppe-fashion/product/bardot-longsleeve/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fbardot-longsleeve&#038;text=Bardot+Longsleeve\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fbardot-longsleeve&#038;t=Bardot+Longsleeve&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fbardot-longsleeve%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fbardot-longsleeve&#038;description=Bardot+Longsleeve&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Ffiles%2F2019%2F08%2Fwomoan-hat.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fbardot-longsleeve&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="313"> <figure ><a href="https://themify.me/demo/themes/shoppe-fashion/product/porcelain-dress/"><img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/cozy-backless-dress-262x287.jpg" width="262" height="287" alt="cozy-backless-dress" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-fashion/product/porcelain-dress/"> <h3>Porcelain Dress</h3> &#36;200.00 </a> Rated <strong>0</strong> out of 5 <a href="/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php?add-to-cart=313" data-quantity="1" data-product_id="313" data-product_sku="" aria-label="Add &ldquo;Porcelain Dress&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-fashion/wp-admin/post.php?post=313&#038;action=edit">Edit</a>] <a data-id="313" onclick="javascript:void(0)" href="#" rel="nofollow"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-fashion/files/woocommerce-placeholder.png" href="https://themify.me/demo/themes/shoppe-fashion/product/porcelain-dress/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fporcelain-dress&#038;text=Porcelain+Dress\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fporcelain-dress&#038;t=Porcelain+Dress&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fporcelain-dress%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fporcelain-dress&#038;description=Porcelain+Dress&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Ffiles%2F2019%2F08%2Fcozy-backless-dress.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fporcelain-dress&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="312"> <figure ><a href="https://themify.me/demo/themes/shoppe-fashion/product/jean-jacket/"><img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/denim-jacket-262x287.jpg" width="262" height="287" alt="denim-jacket" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-fashion/product/jean-jacket/"> <h3>Perfect Jean Jacket</h3> &#36;125.00 </a> Rated <strong>0</strong> out of 5 <a href="/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php?add-to-cart=312" data-quantity="1" data-product_id="312" data-product_sku="" aria-label="Add &ldquo;Perfect Jean Jacket&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-fashion/wp-admin/post.php?post=312&#038;action=edit">Edit</a>] <a data-id="312" onclick="javascript:void(0)" href="#" rel="nofollow"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-fashion/files/woocommerce-placeholder.png" href="https://themify.me/demo/themes/shoppe-fashion/product/jean-jacket/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fjean-jacket&#038;text=Perfect+Jean+Jacket\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fjean-jacket&#038;t=Perfect+Jean+Jacket&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fjean-jacket%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fjean-jacket&#038;description=Perfect+Jean+Jacket&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Ffiles%2F2019%2F08%2Fdenim-jacket.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fjean-jacket&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> <li data-product-id="246"> <figure ><a href="https://themify.me/demo/themes/shoppe-fashion/product/nightgown-set/"><img src="https://themify.me/demo/themes/shoppe-fashion/files/2019/08/night-silk-dress-262x287.jpg" width="262" height="287" alt="night-silk-dress" /></a></figure> <a href="https://themify.me/demo/themes/shoppe-fashion/product/nightgown-set/"> <h3>50s Nightgown Set</h3> &#36;135.00 </a> Rated <strong>0</strong> out of 5 <a href="/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php?add-to-cart=246" data-quantity="1" data-product_id="246" data-product_sku="" aria-label="Add &ldquo;50s Nightgown Set&rdquo; to your cart" rel="nofollow">Add to cart</a>[<a href="https://themify.me/demo/themes/shoppe-fashion/wp-admin/post.php?post=246&#038;action=edit">Edit</a>] <a data-id="246" onclick="javascript:void(0)" href="#" rel="nofollow"> Wishlist </a> <a onclick="return false;" data-image="https://themify.me/demo/themes/shoppe-fashion/files/woocommerce-placeholder.png" href="https://themify.me/demo/themes/shoppe-fashion/product/nightgown-set/?post_in_lightbox=1">Quick Look</a> <a href="javascript:void(0);"></a> <a onclick="window.open(\'//twitter.com/intent/tweet?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fnightgown-set&#038;text=50s+Nightgown+Set\',\'twitter\',\'toolbar=0, status=0, width=650, height=360\')" title="Twitter" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'https://www.facebook.com/sharer/sharer.php?u=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fnightgown-set&#038;t=50s+Nightgown+Set&#038;original_referer=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fnightgown-set%2F\',\'facebook\',\'toolbar=0, status=0, width=900, height=500\')" title="Facebook" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//pinterest.com/pin/create/button/?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fnightgown-set&#038;description=50s+Nightgown+Set&#038;media=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Ffiles%2F2019%2F08%2Fnight-silk-dress.jpg\',\'pinterest\',\'toolbar=no,width=700,height=300\')" title="Pinterest" rel="nofollow" href="javascript:void(0);"></a> <a onclick="window.open(\'//www.linkedin.com/cws/share?url=https%3A%2F%2Fthemify.me%2Fdemo%2Fthemes%2Fshoppe-fashion%2Fproduct%2Fnightgown-set&#038;token=&#038;isFramed=true\',\'linkedin\',\'toolbar=no,width=550,height=550\')" title="LinkedIn" rel="nofollow" href="javascript:void(0);"></a> 
 </li> </ul>
<link id="themify-builder-427-generated" rel="stylesheet" href="https://themify.me/demo/themes/shoppe-fashion/files/themify-css/themify-builder-427-generated.css?ver=1567193118" type="text/css" /> 
 <h3>Exclusive Discounts</h3> <p>Subscribe to our newsletter for a 15% discount!</p> 
 <form name="tb_optin" method="post" action="https://themify.me/demo/themes/shoppe-fashion/wp-admin/admin-ajax.php" data-success="s2" > <input type="hidden" name="action" value="tb_optin_subscribe" /> <input type="hidden" name="tb_optin_redirect" value="" /> <input type="hidden" name="tb_optin_provider" value="mailchimp" />
 <input type="hidden" name="tb_optin_mailchimp_list" value="0f2a95e5de" /> <input type="hidden" name="tb_optin_fname" value="John" /> <input type="hidden" name="tb_optin_lname" value="Doe" /> <label></label> <input type="email" name="tb_optin_email" required="required" /> <button>Subscribe</button> </form> <p>Success!</p><!--/themify_builder_static-->',
  'post_title' => 'Home',
  'post_excerpt' => '',
  'post_name' => 'home',
  'post_modified' => '2019-08-31 06:23:41',
  'post_modified_gmt' => '2019-08-31 06:23:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?page_id=7',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'content_width' => 'full_width',
    'hide_page_title' => 'yes',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"9eo7691\\",\\"cols\\":[{\\"element_id\\":\\"a8sh692\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"mp9t431\\",\\"cols\\":[{\\"element_id\\":\\"7mws431\\",\\"grid_class\\":\\"col3-1\\",\\"grid_width\\":\\"22\\"},{\\"element_id\\":\\"r0vt431\\",\\"grid_class\\":\\"col3-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"a324136\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>The September Issue<\\\\/h1>\\\\n<p>Our latest drop, featuring collaborations with three fashion houses, is exclusively available online now.<\\\\/p>\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\",\\"custom_parallax_scroll_zindex\\":\\"3\\",\\"margin_right_unit\\":\\"%\\",\\"breakpoint_mobile\\":{\\"margin_right_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"10\\",\\"padding_opp_left\\":\\"1\\",\\"padding_right\\":\\"10\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"30\\"},\\"breakpoint_tablet_landscape\\":{\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"55\\"},\\"breakpoint_tablet\\":{\\"margin_right_unit\\":\\"%\\",\\"margin_top\\":\\"50\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_size_h1_unit\\":\\"px\\",\\"font_size_h1\\":\\"35\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"text_align\\":\\"left\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"x1ae80\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\",\\"margin_bottom\\":\\"30\\",\\"margin_top\\":\\"15\\",\\"breakpoint_mobile\\":{\\"margin_right_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"10\\",\\"margin_opp_left\\":\\"1\\",\\"margin_bottom\\":\\"30\\",\\"margin_right\\":\\"10\\",\\"margin_top\\":\\"15\\"}}}],\\"grid_width\\":\\"74.8\\"}],\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"5\\",\\"margin_opp_top\\":\\"1\\",\\"margin_top_unit\\":\\"%\\",\\"margin_top\\":\\"5\\"},\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"6\\"}}],\\"grid_width\\":\\"54\\",\\"styling\\":{\\"font_color\\":\\"#ffffff\\"}},{\\"element_id\\":\\"qkpp978\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"ia6m139\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"770\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/hero-banner-top.jpg\\",\\"style_image\\":\\"image-top\\",\\"margin_top\\":\\"-50\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-20\\",\\"custom_parallax_scroll_zindex\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_top\\":\\"0\\"},\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}],\\"grid_width\\":\\"46\\"}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"col_tablet\\":\\"column4-2\\",\\"col_mobile\\":\\"column-full\\",\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\",\\"background_color\\":\\"ddbc6a\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"margin-top\\":\\"6\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_top_unit\\":\\"%\\",\\"margin-bottom_unit\\":\\"%\\",\\"margin-bottom\\":\\"-10\\",\\"breakpoint_mobile\\":{\\"margin-top\\":\\"0\\",\\"padding_bottom\\":\\"22\\",\\"padding_bottom_unit\\":\\"%\\",\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"0\\",\\"margin-top_unit\\":\\"px\\"},\\"breakpoint_tablet\\":{\\"margin-top\\":\\"0\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"13\\"},\\"breakpoint_tablet_landscape\\":{\\"margin-top\\":\\"33\\",\\"margin-top_unit\\":\\"px\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_bottom\\":\\"10\\",\\"padding_top\\":\\"28\\"},\\"margin-top_unit\\":\\"%\\"}},{\\"element_id\\":\\"sk4q952\\",\\"cols\\":[{\\"element_id\\":\\"48cl954\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"khhy961\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-bag-310x342.jpg\\",\\"style_image\\":\\"image-center\\",\\"border-type\\":\\"top\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-type\\":\\"image\\"}},{\\"element_id\\":\\"12yf953\\",\\"cols\\":[{\\"element_id\\":\\"trzk954\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"fd8v429\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Shop Bags<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_color_type_h4\\":\\"font_color_h4_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"a0pr954\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"jhri954\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"yftm251\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"z7vu260\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/woman-dress-310x342.jpg\\",\\"style_image\\":\\"image-center\\"}},{\\"element_id\\":\\"sc86289\\",\\"cols\\":[{\\"element_id\\":\\"j3n3289\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"osjd717\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Shop Dresses<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"gtkm289\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"r432289\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"40\\"}}},{\\"element_id\\":\\"q9dr251\\",\\"grid_class\\":\\"col3-1\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"el1u792\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"310\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/sunglasses-1-310x342.jpg\\",\\"style_image\\":\\"image-center\\",\\"border-type\\":\\"top\\",\\"background_position\\":\\"left-top\\",\\"background_repeat\\":\\"repeat\\",\\"background_image-type\\":\\"image\\"}},{\\"element_id\\":\\"ukzd281\\",\\"cols\\":[{\\"element_id\\":\\"v52c282\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"mr4z448\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Shop Accessories<\\\\/h3>\\",\\"font_size_h3_unit\\":\\"em\\",\\"font_size_h3\\":\\"2\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\",\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"breakpoint_mobile\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"line_height_h3_unit\\":\\"em\\",\\"line_height_h3\\":\\".9\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"26\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"wktu282\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"View more\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"transparent\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"small\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}},{\\"mod_name\\":\\"divider\\",\\"element_id\\":\\"nlq6282\\",\\"mod_settings\\":{\\"stroke_w_divider\\":\\"1\\",\\"color_divider\\":\\"#000000\\",\\"divider_width\\":\\"40\\",\\"divider_align\\":\\"left\\",\\"divider_type\\":\\"custom\\"}}]}],\\"styling\\":{\\"margin_left\\":\\"-10\\",\\"margin_top\\":\\"-10\\"}}],\\"styling\\":{\\"breakpoint_mobile\\":{\\"margin-bottom_unit\\":\\"px\\",\\"margin-bottom\\":\\"20\\"}}}],\\"gutter\\":\\"gutter-narrow\\",\\"col_tablet\\":\\"column3-1\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"margin-top\\":\\"26\\",\\"margin-top_unit\\":\\"px\\",\\"padding_top\\":\\"0\\"}},{\\"element_id\\":\\"h9dc211\\",\\"cols\\":[{\\"element_id\\":\\"1035214\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ei5u94\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>What\\\\\\\\\\\'s New?<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"75\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"breakpoint_mobile\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"45\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\"},\\"breakpoint_tablet_landscape\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"60\\",\\"font_color_h3\\":\\"#bbbaba\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"cjjw90\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/fashion-bag-image.jpg\\",\\"style_image\\":\\"image-top\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}]},{\\"element_id\\":\\"u853676\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"nlvx410\\",\\"cols\\":[{\\"element_id\\":\\"sg3t410\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"23x1280\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Fall Bag Essentials<\\\\/h3>\\\\n<p>We\\\\\\\\\\\'ve got a full selection of the latest styles for handbags, crossbodies, satchels, totes, and more!<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\",\\"font_color_type_h1\\":\\"font_color_h1_solid\\",\\"font_color_type\\":\\"font_color_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type\\":\\"font_color_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"grxz93\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"padding_opp_left\\":\\"1\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-30\\",\\"margin_bottom_unit\\":\\"%\\",\\"margin_bottom\\":\\"6\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_color\\":\\"#000000_0.13\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset\\":\\"0\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"5\\",\\"checkbox_padding_apply_all\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_right_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_top_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom\\":\\"5\\",\\"padding_right\\":\\"8\\",\\"padding_top\\":\\"8\\"},\\"breakpoint_tablet\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom\\":\\"6\\"},\\"breakpoint_tablet_landscape\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-15\\",\\"margin_bottom\\":\\"6\\"}}}]}],\\"column_alignment\\":\\"col_align_bottom\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\"}},{\\"element_id\\":\\"g5dm610\\",\\"cols\\":[{\\"element_id\\":\\"xaoy611\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"p2e2612\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/fashion-jacket-image.jpg\\",\\"style_image\\":\\"image-top\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}},\\"animation_effect_tab\\":\\"s_e_m\\",\\"breakpoint_mobile\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\"}}}]},{\\"element_id\\":\\"aqol612\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"lh1i612\\",\\"cols\\":[{\\"element_id\\":\\"g5i5613\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"0s4v613\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Coat Season is Upon Us<\\\\/h3>\\\\n<p>There\\\\\\\\\\\'s nothing better than bundling up in an elegant jacket with the air crisp and bright.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"swve613\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"margin_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"margin_bottom\\":\\"5\\",\\"margin_right_unit\\":\\"%\\",\\"margin_right\\":\\"-30\\",\\"b_sh_color\\":\\"#000000_0.11\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\"}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"desktop_dir\\":\\"rtl\\",\\"tablet_dir\\":\\"rtl\\",\\"tablet_landscape_dir\\":\\"rtl\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"6\\",\\"padding_top\\":\\"0\\"}},{\\"element_id\\":\\"aa9a230\\",\\"cols\\":[{\\"element_id\\":\\"e105233\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"image\\",\\"element_id\\":\\"bisu235\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"600\\",\\"url_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/red-earring-girl.jpg\\",\\"style_image\\":\\"image-top\\",\\"motion_effects\\":{\\"v\\":{\\"val\\":{\\"v_vp\\":\\"30,100\\",\\"v_speed\\":\\"1\\",\\"v_dir\\":\\"up\\"}}}}}]},{\\"element_id\\":\\"jy2f235\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"element_id\\":\\"b459235\\",\\"cols\\":[{\\"element_id\\":\\"2aqq236\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"6u5c236\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Show Stopper Earrings<\\\\/h3>\\\\n<p>Glamorous or minimal - our collection of drop dead gorgeous earrings are worth the look.<\\\\/p>\\",\\"breakpoint_mobile\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"},\\"breakpoint_tablet\\":{\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"35\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"font_color_type_h2\\":\\"font_color_h2_solid\\"}}},{\\"mod_name\\":\\"buttons\\",\\"element_id\\":\\"8sdi236\\",\\"mod_settings\\":{\\"content_button\\":[{\\"label\\":\\"Shop Now\\",\\"link\\":\\"https:\\\\/\\\\/themify.me\\\\/\\",\\"link_options\\":\\"regular\\",\\"button_color_bg\\":\\"black\\",\\"icon_alignment\\":\\"left\\"}],\\"display\\":\\"buttons-horizontal\\",\\"buttons_style\\":\\"outline\\",\\"buttons_shape\\":\\"squared\\",\\"buttons_size\\":\\"normal\\",\\"margin_bottom\\":\\"20\\",\\"margin_top\\":\\"10\\",\\"text_transform\\":\\"uppercase\\",\\"font_color_type\\":\\"font_color_solid\\"}}]}],\\"styling\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.10\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"margin_bottom\\":\\"5\\",\\"breakpoint_mobile\\":{\\"margin_bottom_unit\\":\\"%\\",\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"0\\",\\"margin_bottom\\":\\"5\\"}}}]}],\\"column_alignment\\":\\"col_align_middle\\",\\"gutter\\":\\"gutter-none\\",\\"column_h\\":\\"1\\",\\"col_tablet\\":\\"column4-2\\",\\"styling\\":{\\"row_width\\":\\"fullwidth\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"8\\"}},{\\"element_id\\":\\"nfco214\\",\\"cols\\":[{\\"element_id\\":\\"ayns215\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"ipid93\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Our Top Sellers<\\\\/h3>\\",\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"30\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\",\\"text_align\\":\\"center\\",\\"font_color_type\\":\\"font_color_solid\\",\\"padding_bottom\\":\\"35\\",\\"padding_bottom_unit\\":\\"px\\",\\"breakpoint_mobile\\":{\\"font_weight_h3\\":\\"bold\\",\\"font_size_h3_unit\\":\\"px\\",\\"font_size_h3\\":\\"24\\",\\"font_color_type_h3\\":\\"font_color_h3_solid\\"}}},{\\"mod_name\\":\\"products\\",\\"element_id\\":\\"8uqd872\\",\\"mod_settings\\":{\\"post_per_page_products\\":\\"4\\",\\"hide_page_nav_products\\":\\"yes\\",\\"pause_on_hover_slider\\":\\"resume\\",\\"layout_products\\":\\"grid4\\",\\"hide_sales_badge\\":\\"no\\",\\"hide_rating_products\\":\\"no\\",\\"hide_add_to_cart_products\\":\\"no\\",\\"hide_price_products\\":\\"no\\",\\"unlink_post_title_products\\":\\"no\\",\\"show_product_tags\\":\\"no\\",\\"show_product_categories\\":\\"no\\",\\"hide_post_title_products\\":\\"no\\",\\"unlink_feat_img_products\\":\\"no\\",\\"hide_feat_img_products\\":\\"no\\",\\"description_products\\":\\"none\\",\\"height_slider\\":\\"variable\\",\\"show_arrow_slider\\":\\"yes\\",\\"show_nav_slider\\":\\"yes\\",\\"wrap_slider\\":\\"yes\\",\\"effect_slider\\":\\"scroll\\",\\"speed_opt_slider\\":\\"normal\\",\\"scroll_opt_slider\\":\\"1\\",\\"auto_scroll_opt_slider\\":\\"1\\",\\"mob_visible_opt_slider\\":\\"0\\",\\"visible_opt_slider\\":\\"1\\",\\"layout_slider\\":\\"slider-default\\",\\"template_products\\":\\"list\\",\\"order_products\\":\\"desc\\",\\"orderby_products\\":\\"date\\",\\"hide_outofstock_products\\":\\"no\\",\\"hide_free_products\\":\\"no\\",\\"hide_child_products\\":\\"no\\",\\"category_products\\":\\"0|single\\",\\"query_products\\":\\"featured\\",\\"img_height_products\\":\\"287\\",\\"img_width_products\\":\\"262\\",\\"breakpoint_mobile\\":{\\"f_s_p_t_unit\\":\\"px\\",\\"f_s_p_t\\":\\"22\\",\\"p_p_p_left\\":\\"30\\",\\"p_p_t_left\\":\\"30\\"},\\"breakpoint_tablet\\":{\\"p_p_p_left\\":\\"30\\",\\"p_p_t_left\\":\\"30\\",\\"f_s_p_t_unit\\":\\"px\\",\\"f_s_p_t\\":\\"28\\"},\\"breakpoint_tablet_landscape\\":{\\"p_p_t_left\\":\\"30\\",\\"p_p_p_left\\":\\"30\\",\\"f_s_p_t_unit\\":\\"px\\",\\"f_s_p_t\\":\\"36\\"}}}]}]},{\\"element_id\\":\\"rtes804\\",\\"cols\\":[{\\"element_id\\":\\"p7qi804\\",\\"grid_class\\":\\"col-full\\",\\"modules\\":[{\\"mod_name\\":\\"layout-part\\",\\"element_id\\":\\"wvn0805\\",\\"mod_settings\\":{\\"selected_layout_part\\":\\"newsletter-row\\"}}]}],\\"styling\\":{\\"row_width\\":\\"fullwidth-content\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 23,
  'post_date' => '2019-08-09 02:16:54',
  'post_date_gmt' => '2019-08-09 02:16:54',
  'post_content' => '<!-- wp:shortcode -->[woocommerce_my_account]<!-- /wp:shortcode -->',
  'post_title' => 'My account',
  'post_excerpt' => '',
  'post_name' => 'my-account',
  'post_modified' => '2019-08-09 02:16:54',
  'post_modified_gmt' => '2019-08-09 02:16:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/my-account/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 20,
  'post_date' => '2019-08-09 02:16:54',
  'post_date_gmt' => '2019-08-09 02:16:54',
  'post_content' => '',
  'post_title' => 'Shop',
  'post_excerpt' => '',
  'post_name' => 'shop',
  'post_modified' => '2019-08-09 02:16:54',
  'post_modified_gmt' => '2019-08-09 02:16:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/shop/',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 375,
  'post_date' => '2019-08-27 21:33:21',
  'post_date_gmt' => '2019-08-27 21:33:21',
  'post_content' => '<!-- wp:themify-builder/canvas /-->',
  'post_title' => 'Wishlist',
  'post_excerpt' => '',
  'post_name' => 'wishlist',
  'post_modified' => '2019-08-27 21:33:22',
  'post_modified_gmt' => '2019-08-27 21:33:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?page_id=375',
  'menu_order' => 0,
  'post_type' => 'page',
  'meta_input' => 
  array (
    'page_layout' => 'sidebar-none',
    'mobile_menu_styles' => 'default',
    'product_query_type' => 'all',
    'product_archive_show_short' => 'excerpt',
    'product_hide_navigation' => 'no',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 427,
  'post_date' => '2019-08-29 20:34:46',
  'post_date_gmt' => '2019-08-29 20:34:46',
  'post_content' => '<!--themify_builder_static--><h3>Exclusive Discounts</h3> <p>Subscribe to our newsletter for a 15% discount!</p>
<!--/themify_builder_static-->',
  'post_title' => 'Newsletter Row',
  'post_excerpt' => '',
  'post_name' => 'newsletter-row',
  'post_modified' => '2019-08-30 19:25:18',
  'post_modified_gmt' => '2019-08-30 19:25:18',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/tbuilder-layout-part/newsletter-row/',
  'menu_order' => 0,
  'post_type' => 'tbuilder_layout_part',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"375f932\\",\\"cols\\":[{\\"element_id\\":\\"ujha932\\",\\"grid_class\\":\\"col4-2\\",\\"modules\\":[{\\"mod_name\\":\\"text\\",\\"element_id\\":\\"p51j932\\",\\"mod_settings\\":{\\"content_text\\":\\"<h3>Exclusive Discounts<\\\\/h3>\\\\n<p>Subscribe to our newsletter for a 15% discount!<\\\\/p>\\",\\"font_size_unit\\":\\"em\\",\\"font_size\\":\\"1.1\\",\\"font_color_type\\":\\"font_color_solid\\",\\"breakpoint_tablet_landscape\\":{\\"padding_left\\":\\"40\\"}}},{\\"mod_name\\":\\"optin\\",\\"element_id\\":\\"gdry932\\",\\"mod_settings\\":{\\"label_firstname\\":\\"First Name\\",\\"default_fname\\":\\"John\\",\\"label_lastname\\":\\"Last Name\\",\\"default_lname\\":\\"Doe\\",\\"label_submit\\":\\"Subscribe\\",\\"message\\":\\"<p>Success!<\\\\/p>\\",\\"success_action\\":\\"s2\\",\\"lname_hide\\":\\"1\\",\\"fname_hide\\":\\"1\\",\\"layout\\":\\"tb_optin_horizontal\\",\\"provider\\":\\"mailchimp\\",\\"f_c_t\\":\\"f_c_solid\\",\\"b_r\\":\\"repeat\\",\\"b_i-type\\":\\"image\\",\\"breakpoint_tablet_landscape\\":{\\"p_left\\":\\"40\\"},\\"mailchimp_list\\":\\"0f2a95e5de\\"}}],\\"styling\\":{\\"font_color\\":\\"#ffffff\\",\\"breakpoint_mobile\\":{\\"padding_left\\":\\"30\\",\\"padding_right\\":\\"30\\"}}},{\\"element_id\\":\\"qjj2932\\",\\"grid_class\\":\\"col4-2\\"}],\\"styling\\":{\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"11\\",\\"padding_opp_top\\":\\"1\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"11\\",\\"background_position\\":\\"50,50\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"fullcover\\",\\"background_image\\":\\"https://themify.me/demo/themes/shoppe-fashion\\\\/files\\\\/2019\\\\/08\\\\/shoppe-newsletter-bg.jpg\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"background_type\\":\\"image\\",\\"row_width\\":\\"fullwidth\\"}}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 424,
  'post_date' => '2019-08-29 20:33:17',
  'post_date_gmt' => '2019-08-29 20:33:17',
  'post_content' => '<!--themify_builder_static--><img src="https://themify.me/demo/themes/ultra-fashion/files/2019/08/nadya-summer.jpg" width="308" title="Nadya Catherine" alt="Nadya Catherine" /> <h3> Nadya Catherine </h3><!--/themify_builder_static-->',
  'post_title' => 'Shoppe Fashion Team GS',
  'post_excerpt' => '',
  'post_name' => 'tb_gs4245d6',
  'post_modified' => '2019-08-29 20:33:17',
  'post_modified_gmt' => '2019-08-29 20:33:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/tglobal-style/shoppe-fashion-team-gs/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"element_id\\":\\"row5d68368d1edd0\\",\\"styling\\":{\\"global_styles\\":\\" \\"},\\"cols\\":[{\\"column_order\\":\\"0\\",\\"element_id\\":\\"col5d68368d1edd0\\",\\"grid_class\\":\\"col-full\\",\\"styling\\":{\\"global_styles\\":\\" \\"},\\"modules\\":[{\\"element_id\\":\\"mod5d68368d1edd0\\",\\"mod_name\\":\\"image\\",\\"mod_settings\\":{\\"param_image\\":\\"regular\\",\\"width_image\\":\\"308\\",\\"url_image\\":\\"https:\\\\/\\\\/themify.me\\\\/demo\\\\/themes\\\\/ultra-fashion\\\\/files\\\\/2019\\\\/08\\\\/nadya-summer.jpg\\",\\"style_image\\":\\"image-center\\",\\"title_image\\":\\"Nadya Catherine\\",\\"i_t_sh_inset\\":\\"false\\",\\"i_t_sh_color\\":\\"#ddbc6a\\",\\"i_t_sh_blur_unit\\":\\"px\\",\\"i_t_sh_blur\\":\\"0\\",\\"i_t_sh_vOffset_unit\\":\\"px\\",\\"i_t_sh_vOffset\\":\\"20\\",\\"i_t_sh_hOffset_unit\\":\\"px\\",\\"i_t_sh_hOffset\\":\\"-20\\",\\"checkbox_i_t_m_apply_all\\":\\"false\\",\\"i_t_m_left_unit\\":\\"px\\",\\"i_t_m_opp_left\\":\\"false\\",\\"i_t_m_bottom_unit\\":\\"px\\",\\"i_t_m_bottom\\":\\"30\\",\\"i_t_m_right_unit\\":\\"px\\",\\"i_t_m_opp_top\\":\\"false\\",\\"i_t_m_top_unit\\":\\"px\\"}}]}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 179,
  'post_date' => '2019-08-12 07:44:36',
  'post_date_gmt' => '2019-08-12 07:44:36',
  'post_content' => '<!--themify_builder_static--><h1>Heading 1</h1><h2>Heading 2</h2><h3>Heading 3</h3><h4>Heading 4</h4><p>This is a sample Text module.</p><!--/themify_builder_static-->',
  'post_title' => 'Box Shadow',
  'post_excerpt' => '',
  'post_name' => 'tb_gs1795d5',
  'post_modified' => '2019-08-12 07:44:36',
  'post_modified_gmt' => '2019-08-12 07:44:36',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/tglobal-style/box-shadow/',
  'menu_order' => 0,
  'post_type' => 'tglobal_style',
  'meta_input' => 
  array (
    '_themify_builder_settings_json' => '[{\\"row_order\\":\\"0\\",\\"element_id\\":\\"row5d5118e45ec16\\",\\"styling\\":{\\"margin_left_unit\\":\\"%\\",\\"margin_left\\":\\"-10\\",\\"margin_bottom_unit\\":\\"%\\",\\"padding_left_unit\\":\\"%\\",\\"padding_left\\":\\"8\\",\\"padding_opp_left\\":\\"1\\",\\"padding_bottom_unit\\":\\"%\\",\\"padding_bottom\\":\\"5\\",\\"padding_right_unit\\":\\"%\\",\\"padding_right\\":\\"8\\",\\"padding_top_unit\\":\\"%\\",\\"padding_top\\":\\"8\\",\\"background_color\\":\\"#ffffff\\",\\"background_position\\":\\"center-center\\",\\"background_attachment\\":\\"scroll\\",\\"background_repeat\\":\\"repeat\\",\\"background_video_options\\":\\"mute\\",\\"background_slider_speed\\":\\"2000\\",\\"background_slider_mode\\":\\"fullcover\\",\\"background_slider_size\\":\\"large\\",\\"b_sh_color\\":\\"#000000_0.08\\",\\"b_sh_blur_unit\\":\\"px\\",\\"b_sh_blur\\":\\"20\\",\\"b_sh_vOffset_unit\\":\\"px\\",\\"b_sh_vOffset\\":\\"0\\",\\"b_sh_hOffset_unit\\":\\"px\\",\\"b_sh_hOffset\\":\\"0\\",\\"margin_bottom\\":\\"5\\",\\"b_sh_inset\\":\\"false\\",\\"global_styles\\":\\"\\"},\\"cols\\":[{\\"column_order\\":\\"0\\",\\"element_id\\":\\"col5d5118e45ec16\\",\\"grid_class\\":\\"col-full\\",\\"styling\\":{\\"global_styles\\":\\" \\"},\\"modules\\":[{\\"element_id\\":\\"mod5d5118e45ec16\\",\\"mod_name\\":\\"text\\",\\"mod_settings\\":{\\"content_text\\":\\"<h1>Heading 1<\\\\/h1><h2>Heading 2<\\\\/h2><h3>Heading 3<\\\\/h3><h4>Heading 4<\\\\/h4><p>This is a sample Text module.<\\\\/p>\\"}}]}]}]',
  ),
  'tax_input' => 
  array (
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 315,
  'post_date' => '2019-08-25 07:43:03',
  'post_date_gmt' => '2019-08-25 07:43:03',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Bardot Longsleeve',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur.',
  'post_name' => 'bardot-longsleeve',
  'post_modified' => '2019-08-26 21:20:45',
  'post_modified_gmt' => '2019-08-26 21:20:45',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=315',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854445:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"bi1k586\\",\\"cols\\":[{\\"element_id\\":\\"euoz588\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
    '_thumbnail_id' => '351',
    '_wp_old_slug' => 'denim-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/womoan-hat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 314,
  'post_date' => '2019-08-25 07:41:08',
  'post_date_gmt' => '2019-08-25 07:41:08',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Siobhan Knit Sweater',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.',
  'post_name' => 'knit-sweater',
  'post_modified' => '2019-08-27 18:53:29',
  'post_modified_gmt' => '2019-08-27 18:53:29',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=314',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932009:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"sn1l207\\",\\"cols\\":[{\\"element_id\\":\\"lorc209\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '175',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '175',
    '_thumbnail_id' => '332',
    '_wp_old_slug' => 'midi-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/brown-sweater.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 313,
  'post_date' => '2019-08-25 07:35:24',
  'post_date_gmt' => '2019-08-25 07:35:24',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Porcelain Dress',
  'post_excerpt' => 'Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.',
  'post_name' => 'porcelain-dress',
  'post_modified' => '2019-08-26 21:23:02',
  'post_modified_gmt' => '2019-08-26 21:23:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=313',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854582:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"y53s816\\",\\"cols\\":[{\\"element_id\\":\\"2aqr817\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '200',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '200',
    '_thumbnail_id' => '333',
    '_wp_old_slug' => 'red-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/cozy-backless-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 312,
  'post_date' => '2019-08-25 07:33:59',
  'post_date_gmt' => '2019-08-25 07:33:59',
  'post_content' => ' Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Perfect Jean Jacket',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'jean-jacket',
  'post_modified' => '2019-08-26 21:23:25',
  'post_modified_gmt' => '2019-08-26 21:23:25',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=312',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854605:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"5pml268\\",\\"cols\\":[{\\"element_id\\":\\"pyl0270\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
    '_thumbnail_id' => '334',
    '_wp_old_slug' => 'sheath-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/denim-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 310,
  'post_date' => '2019-08-25 07:33:14',
  'post_date_gmt' => '2019-08-25 07:33:14',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Cropped V Sleeveless',
  'post_excerpt' => 'Magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur.',
  'post_name' => 'c-sleeveless',
  'post_modified' => '2019-08-27 18:53:41',
  'post_modified_gmt' => '2019-08-27 18:53:41',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=310',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932021:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"p6lf771\\",\\"cols\\":[{\\"element_id\\":\\"fhmo773\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '120',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '120',
    '_thumbnail_id' => '335',
    '_wp_old_slug' => 'india-motive',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/ethnic-motive-inner-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 304,
  'post_date' => '2019-08-25 07:10:34',
  'post_date_gmt' => '2019-08-25 07:10:34',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => 'Print Cutout Dress',
  'post_excerpt' => 'Adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem.

',
  'post_name' => 'print-dress',
  'post_modified' => '2019-08-27 18:53:49',
  'post_modified_gmt' => '2019-08-27 18:53:49',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=304',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932029:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"iu45651\\",\\"cols\\":[{\\"element_id\\":\\"15yw654\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '175',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '175',
    '_thumbnail_id' => '336',
    '_wp_old_slug' => 'gray-tank-top',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/ethnic-newspaper-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 302,
  'post_date' => '2019-08-25 07:06:29',
  'post_date_gmt' => '2019-08-25 07:06:29',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Fitted Girlfriend Jean Jacked',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'fitted-jean-jacket',
  'post_modified' => '2019-08-26 21:26:27',
  'post_modified_gmt' => '2019-08-26 21:26:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=302',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854787:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"vig8254\\",\\"cols\\":[{\\"element_id\\":\\"i7q1257\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '150',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '150',
    '_thumbnail_id' => '337',
    '_wp_old_slug' => 'flaire-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/full-denim-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 300,
  'post_date' => '2019-08-25 06:59:13',
  'post_date_gmt' => '2019-08-25 06:59:13',
  'post_content' => 'Deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum. Excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum.',
  'post_title' => 'Striped Tank',
  'post_excerpt' => 'Vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias.',
  'post_name' => 'striped-tank',
  'post_modified' => '2019-08-26 21:26:52',
  'post_modified_gmt' => '2019-08-26 21:26:52',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=300',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854812:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"1rgo903\\",\\"cols\\":[{\\"element_id\\":\\"8rsv906\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '90',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '90',
    '_thumbnail_id' => '338',
    '_wp_old_slug' => 'summer-shirt',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/half-top-blue-line.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 299,
  'post_date' => '2019-08-25 06:57:06',
  'post_date_gmt' => '2019-08-25 06:57:06',
  'post_content' => 'At vero eos et accusamus et iusto odio dignissimos ducimus qui blanditiis praesentium voluptatum deleniti atque corrupti quos dolores et quas molestias excepturi sint occaecati cupiditate non provident, similique sunt in culpa qui officia deserunt mollitia animi, id est laborum et dolorum fuga. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.',
  'post_title' => 'Chelsea Leather Bomber',
  'post_excerpt' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt.',
  'post_name' => 'leather-bomber',
  'post_modified' => '2019-08-27 18:54:02',
  'post_modified_gmt' => '2019-08-27 18:54:02',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=299',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932042:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"40s7889\\",\\"cols\\":[{\\"element_id\\":\\"kpuc891\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '275',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '275',
    '_thumbnail_id' => '339',
    '_wp_old_slug' => 'exotic-stripe',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/leather-jacket.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 247,
  'post_date' => '2019-08-23 02:39:53',
  'post_date_gmt' => '2019-08-23 02:39:53',
  'post_content' => 'Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur.',
  'post_title' => 'Priyanka Onesie',
  'post_excerpt' => 'Voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est qui dolorem ipsum quia dolor sit amet consectetur adipisci velit.',
  'post_name' => 'priyanka-onesie',
  'post_modified' => '2019-08-26 21:29:17',
  'post_modified_gmt' => '2019-08-26 21:29:17',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=247',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854957:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"zs3e996\\",\\"cols\\":[{\\"element_id\\":\\"w3tm998\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '150',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '150',
    '_wp_old_slug' => '247',
    '_thumbnail_id' => '340',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/modern-new-school-tanktop.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 246,
  'post_date' => '2019-08-23 02:39:10',
  'post_date_gmt' => '2019-08-23 02:39:10',
  'post_content' => 'Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.',
  'post_title' => '50s Nightgown Set',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia.',
  'post_name' => 'nightgown-set',
  'post_modified' => '2019-08-26 21:29:44',
  'post_modified_gmt' => '2019-08-26 21:29:44',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=246',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566854984:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"2q6p368\\",\\"cols\\":[{\\"element_id\\":\\"6dzd370\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '135',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '135',
    '_wp_old_slug' => '246',
    '_thumbnail_id' => '341',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/night-silk-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 244,
  'post_date' => '2019-08-23 02:37:03',
  'post_date_gmt' => '2019-08-23 02:37:03',
  'post_content' => 'Temporibus autem quibusdam et aut officiis debitis aut rerum necessitatibus saepe eveniet ut et voluptates repudiandae sint et molestiae non recusandae. Itaque earum rerum hic tenetur a sapiente delectus, ut aut reiciendis voluptatibus maiores alias consequatur aut perferendis doloribus asperiores repellat. Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit quo minus id quod maxime placeat facere possimus, omnis voluptas assumenda est, omnis dolor repellendus.

',
  'post_title' => 'Bella Jean Shorts',
  'post_excerpt' => 'Et harum quidem rerum facilis est et expedita distinctio. Nam libero tempore, cum soluta nobis est eligendi optio cumque nihil impedit.',
  'post_name' => 'jean-shorts',
  'post_modified' => '2019-08-27 18:54:15',
  'post_modified_gmt' => '2019-08-27 18:54:15',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=244',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567232773:172',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"hh1f23\\",\\"cols\\":[{\\"element_id\\":\\"1vp828\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
    '_wp_old_slug' => '244',
    '_thumbnail_id' => '342',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sexy-biker-outfit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 243,
  'post_date' => '2019-08-23 02:31:25',
  'post_date_gmt' => '2019-08-23 02:31:25',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'McAuley Fitted Blazer',
  'post_excerpt' => 'Eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco.',
  'post_name' => 'fitted-blazer',
  'post_modified' => '2019-08-27 18:55:27',
  'post_modified_gmt' => '2019-08-27 18:55:27',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=243',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932127:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"xkf9211\\",\\"cols\\":[{\\"element_id\\":\\"wxct214\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '170',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '130',
    '_wp_old_slug' => '243',
    '_thumbnail_id' => '343',
    '_sale_price' => '130',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sexy-blazers.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 241,
  'post_date' => '2019-08-23 02:28:45',
  'post_date_gmt' => '2019-08-23 02:28:45',
  'post_content' => 'Voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.',
  'post_title' => 'Cropped Jersey Hoodie Top',
  'post_excerpt' => 'Numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam.',
  'post_name' => 'cropped-hoodie',
  'post_modified' => '2019-08-26 21:31:22',
  'post_modified_gmt' => '2019-08-26 21:31:22',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=241',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566855082:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"yww134\\",\\"cols\\":[{\\"element_id\\":\\"kvj540\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '135',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '135',
    '_wp_old_slug' => '241',
    '_thumbnail_id' => '344',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sexy-half-shirt.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 240,
  'post_date' => '2019-08-23 02:27:28',
  'post_date_gmt' => '2019-08-23 02:27:28',
  'post_content' => ' Sed ut perspiciatis unde omnis iste natus error sit voluptatem accusantium doloremque laudantium, totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo. Nemo enim ipsam voluptatem quia voluptas sit aspernatur aut odit aut fugit, sed quia consequuntur magni dolores eos qui ratione voluptatem sequi nesciunt. Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid.
',
  'post_title' => 'The Kylie Two-Piece Set',
  'post_excerpt' => 'Totam rem aperiam, eaque ipsa quae ab illo inventore veritatis et quasi architecto beatae vitae dicta sunt explicabo.',
  'post_name' => 'kylie-set',
  'post_modified' => '2019-08-27 18:54:26',
  'post_modified_gmt' => '2019-08-27 18:54:26',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=240',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932066:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"4hqt345\\",\\"cols\\":[{\\"element_id\\":\\"u7l2348\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '230',
    '_wp_old_slug' => '240',
    '_regular_price' => '230',
    '_thumbnail_id' => '345',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/sexy-inner-suit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 239,
  'post_date' => '2019-08-23 02:25:54',
  'post_date_gmt' => '2019-08-23 02:25:54',
  'post_content' => 'Neque porro quisquam est, qui dolorem ipsum quia dolor sit amet, consectetur, adipisci velit, sed quia non numquam eius modi tempora incidunt ut labore et dolore magnam aliquam quaerat voluptatem. Ut enim ad minima veniam, quis nostrum exercitationem ullam corporis suscipit laboriosam, nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam nihil molestiae consequatur, vel illum qui dolorem eum fugiat quo voluptas nulla pariatur.

',
  'post_title' => 'Lola Lace Longsleeve',
  'post_excerpt' => 'Nisi ut aliquid ex ea commodi consequatur? Quis autem vel eum iure reprehenderit qui in ea voluptate velit esse quam.',
  'post_name' => 'lace-longsleeve',
  'post_modified' => '2019-08-27 18:54:34',
  'post_modified_gmt' => '2019-08-27 18:54:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=239',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932074:463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"t7u5998\\",\\"cols\\":[{\\"element_id\\":\\"bvnd3\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    '_edit_last' => '463',
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '140',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '140',
    '_wp_old_slug' => '239',
    '_thumbnail_id' => '346',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-lace.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 90,
  'post_date' => '2019-08-09 08:33:03',
  'post_date_gmt' => '2019-08-09 08:33:03',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'The Fenty One-Piece',
  'post_excerpt' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'fenty-onepiece',
  'post_modified' => '2019-08-29 04:31:34',
  'post_modified_gmt' => '2019-08-29 04:31:34',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=90',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567053157:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"ni3r539\\",\\"cols\\":[{\\"element_id\\":\\"hff2540\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '450',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '450',
    '_thumbnail_id' => '347',
    '_wp_old_slug' => 'sexy-dress',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-dress-suit.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 89,
  'post_date' => '2019-08-09 08:27:51',
  'post_date_gmt' => '2019-08-09 08:27:51',
  'post_content' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Lilac Lace Two-Piece',
  'post_excerpt' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'lace-twopiece',
  'post_modified' => '2019-08-27 18:55:00',
  'post_modified_gmt' => '2019-08-27 18:55:00',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=89',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566932100:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"nzd9119\\",\\"cols\\":[{\\"element_id\\":\\"x3jn121\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '175',
    '_sale_price' => '150',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '150',
    '_wp_old_slug' => 'yellow-retro-dress',
    '_thumbnail_id' => '348',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'accessories',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-elegant-dress.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 87,
  'post_date' => '2019-08-09 08:23:18',
  'post_date_gmt' => '2019-08-09 08:23:18',
  'post_content' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'Boho Chic Top',
  'post_excerpt' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'boho-top',
  'post_modified' => '2019-08-26 21:34:03',
  'post_modified_gmt' => '2019-08-26 21:34:03',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=87',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1566855243:463',
    '_edit_last' => '463',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"7u4z511\\",\\"cols\\":[{\\"element_id\\":\\"h9bl512\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
    '_thumbnail_id' => '349',
    '_wp_old_slug' => 'white-tanktop',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/white-half-top.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 79,
  'post_date' => '2019-08-09 07:43:31',
  'post_date_gmt' => '2019-08-09 07:43:31',
  'post_content' => 'Lorem ipsum dolor sit amet, consectetur adipiscing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_title' => 'That 70s Dress',
  'post_excerpt' => 'Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.',
  'post_name' => 'summer-dress',
  'post_modified' => '2019-08-29 04:32:13',
  'post_modified_gmt' => '2019-08-29 04:32:13',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?post_type=product&#038;p=79',
  'menu_order' => 0,
  'post_type' => 'product',
  'meta_input' => 
  array (
    '_edit_lock' => '1567053153:172',
    '_edit_last' => '172',
    '_themify_builder_settings_json' => '[{\\"element_id\\":\\"tigt341\\",\\"cols\\":[{\\"element_id\\":\\"7ii8342\\",\\"grid_class\\":\\"col-full\\"}]}]',
    'themify_used_global_styles' => 
    array (
      0 => '',
    ),
    'content_width' => 'default_width',
    'image_layout' => 'img-left',
    'mobile_menu_styles' => 'default',
    '_regular_price' => '125',
    'total_sales' => '0',
    '_tax_status' => 'taxable',
    '_manage_stock' => 'no',
    '_backorders' => 'no',
    '_sold_individually' => 'no',
    '_virtual' => 'no',
    '_downloadable' => 'no',
    '_download_limit' => '-1',
    '_download_expiry' => '-1',
    '_stock' => NULL,
    '_stock_status' => 'instock',
    '_wc_average_rating' => '0',
    '_wc_review_count' => '0',
    '_product_version' => '3.6.5',
    '_price' => '125',
    '_thumbnail_id' => '350',
  ),
  'tax_input' => 
  array (
    'product_type' => 'simple',
    'product_visibility' => 'featured',
    'product_cat' => 'women',
  ),
  'thumb' => 'https://themify.me/demo/themes/shoppe-fashion/files/2019/08/woman-brown-hat.jpg',
);
themify_process_post_import( $post );


$post = array (
  'ID' => 30,
  'post_date' => '2019-08-09 02:18:32',
  'post_date_gmt' => '2019-08-09 02:18:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '30',
  'post_modified' => '2019-09-02 21:47:54',
  'post_modified_gmt' => '2019-09-02 21:47:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=30',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '7',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 26,
  'post_date' => '2019-08-09 02:18:33',
  'post_date_gmt' => '2019-08-09 02:18:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '26',
  'post_modified' => '2019-09-02 21:47:54',
  'post_modified_gmt' => '2019-09-02 21:47:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=26',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '20',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 29,
  'post_date' => '2019-08-09 02:18:32',
  'post_date_gmt' => '2019-08-09 02:18:32',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '29',
  'post_modified' => '2019-09-02 21:47:54',
  'post_modified_gmt' => '2019-09-02 21:47:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=29',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '10',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 28,
  'post_date' => '2019-08-09 02:18:33',
  'post_date_gmt' => '2019-08-09 02:18:33',
  'post_content' => ' ',
  'post_title' => '',
  'post_excerpt' => '',
  'post_name' => '28',
  'post_modified' => '2019-09-02 21:47:54',
  'post_modified_gmt' => '2019-09-02 21:47:54',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=28',
  'menu_order' => 4,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'post_type',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '13',
    '_menu_item_object' => 'page',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'main-navigation',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 328,
  'post_date' => '2019-08-26 01:29:10',
  'post_date_gmt' => '2019-08-26 01:29:10',
  'post_content' => '',
  'post_title' => 'Instagram',
  'post_excerpt' => '',
  'post_name' => 'instagram',
  'post_modified' => '2019-08-27 21:39:04',
  'post_modified_gmt' => '2019-08-27 21:39:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=328',
  'menu_order' => 1,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '328',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://www.instagram.com/themify/',
    '_menu_item_icon' => 'ti-instagram',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social-icon',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 329,
  'post_date' => '2019-08-26 01:33:54',
  'post_date_gmt' => '2019-08-26 01:33:54',
  'post_content' => '',
  'post_title' => 'Twitter',
  'post_excerpt' => '',
  'post_name' => 'twitter',
  'post_modified' => '2019-08-27 21:39:04',
  'post_modified_gmt' => '2019-08-27 21:39:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=329',
  'menu_order' => 2,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '329',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://twitter.com/themify',
    '_menu_item_icon' => 'ti-twitter-alt',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social-icon',
  ),
);
themify_process_post_import( $post );


$post = array (
  'ID' => 330,
  'post_date' => '2019-08-26 01:33:54',
  'post_date_gmt' => '2019-08-26 01:33:54',
  'post_content' => '',
  'post_title' => 'Facebook',
  'post_excerpt' => '',
  'post_name' => 'facebook',
  'post_modified' => '2019-08-27 21:39:04',
  'post_modified_gmt' => '2019-08-27 21:39:04',
  'post_content_filtered' => '',
  'post_parent' => 0,
  'guid' => 'https://themify.me/demo/themes/shoppe-fashion/?p=330',
  'menu_order' => 3,
  'post_type' => 'nav_menu_item',
  'xfn' => '',
  'meta_input' => 
  array (
    '_menu_item_type' => 'custom',
    '_menu_item_menu_item_parent' => '0',
    '_menu_item_object_id' => '330',
    '_menu_item_object' => 'custom',
    '_menu_item_classes' => 
    array (
      0 => '',
    ),
    '_menu_item_url' => 'https://www.facebook.com/themify',
    '_menu_item_icon' => 'ti-facebook',
  ),
  'tax_input' => 
  array (
    'nav_menu' => 'social-icon',
  ),
);
themify_process_post_import( $post );



function themify_import_get_term_id_from_slug( $slug ) {
	$menu = get_term_by( "slug", $slug, "nav_menu" );
	return is_wp_error( $menu ) ? 0 : (int) $menu->term_id;
}

	$widgets = get_option( "widget_text" );
$widgets[1002] = array (
  'title' => '',
  'text' => 'Create the ultimate fashion destination with the Shoppe Fashion skin. Shoppe is a powerful eCommerce theme created by Themify, using WooCommerce, and is highly customizable. Discover the entire collection of Shoppe skins today!',
  'filter' => true,
  'visual' => true,
);
update_option( "widget_text", $widgets );

$widgets = get_option( "widget_themify-social-links" );
$widgets[1003] = array (
  'title' => 'Social',
  'show_link_name' => 'on',
  'open_new_window' => NULL,
  'icon_size' => 'icon-medium',
  'orientation' => 'vertical',
);
update_option( "widget_themify-social-links", $widgets );

$widgets = get_option( "widget_woocommerce_product_categories" );
$widgets[1004] = array (
  'title' => 'Product categories',
  'orderby' => 'order',
  'dropdown' => 0,
  'count' => 0,
  'hierarchical' => 1,
  'show_children_only' => 0,
  'hide_empty' => 0,
  'max_depth' => '',
);
update_option( "widget_woocommerce_product_categories", $widgets );

$widgets = get_option( "widget_nav_menu" );
$widgets[1005] = array (
  'title' => 'Sitemap',
  'nav_menu' => themify_import_get_term_id_from_slug( "main-navigation" ),
);
update_option( "widget_nav_menu", $widgets );



$sidebars_widgets = array (
  'below-logo-widget' => 
  array (
    0 => 'text-1002',
  ),
  'footer-widget-1' => 
  array (
    0 => 'themify-social-links-1003',
  ),
  'footer-widget-2' => 
  array (
    0 => 'woocommerce_product_categories-1004',
  ),
  'footer-widget-3' => 
  array (
    0 => 'nav_menu-1005',
  ),
); 
update_option( "sidebars_widgets", $sidebars_widgets );

$menu_locations = array();
$menu = get_terms( "nav_menu", array( "slug" => "main-navigation" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["main-nav"] = $menu[0]->term_id;
$menu = get_terms( "nav_menu", array( "slug" => "social-icon" ) );
if( is_array( $menu ) && ! empty( $menu ) ) $menu_locations["icon-menu"] = $menu[0]->term_id;
set_theme_mod( "nav_menu_locations", $menu_locations );


$homepage = get_posts( array( 'name' => 'home', 'post_type' => 'page' ) );
			if( is_array( $homepage ) && ! empty( $homepage ) ) {
				update_option( 'show_on_front', 'page' );
				update_option( 'page_on_front', $homepage[0]->ID );
			}
			
	ob_start(); ?>a:86:{s:21:"setting-webfonts_list";s:11:"recommended";s:22:"setting-default_layout";s:8:"sidebar1";s:27:"setting-default_post_layout";s:9:"list-post";s:20:"setting-post_masonry";s:3:"yes";s:19:"setting-post_gutter";s:6:"gutter";s:30:"setting-default_layout_display";s:7:"content";s:25:"setting-default_more_text";s:4:"More";s:21:"setting-index_orderby";s:4:"date";s:19:"setting-index_order";s:4:"DESC";s:30:"setting-default_media_position";s:5:"above";s:31:"setting-image_post_feature_size";s:5:"blank";s:32:"setting-default_page_post_layout";s:8:"sidebar1";s:38:"setting-image_post_single_feature_size";s:5:"blank";s:28:"setting-search-result_layout";s:8:"sidebar1";s:33:"setting-search-result_post_layout";s:9:"list-post";s:36:"setting-search-result_layout_display";s:7:"content";s:36:"setting-search-result_media_position";s:5:"above";s:27:"setting-default_page_layout";s:8:"sidebar1";s:53:"setting-customizer_responsive_design_tablet_landscape";s:4:"1280";s:43:"setting-customizer_responsive_design_tablet";s:3:"768";s:43:"setting-customizer_responsive_design_mobile";s:3:"680";s:33:"setting-mobile_menu_trigger_point";s:3:"900";s:24:"setting-gallery_lightbox";s:8:"lightbox";s:27:"setting-page_builder_expiry";s:1:"2";s:21:"setting-header_design";s:12:"header-block";s:21:"setting-footer_design";s:18:"footer-left-column";s:22:"setting-footer_widgets";s:17:"footerwidget-3col";s:23:"setting-mega_menu_posts";s:1:"5";s:29:"setting-mega_menu_image_width";s:3:"180";s:30:"setting-mega_menu_image_height";s:3:"120";s:27:"setting-imagefilter_applyto";s:12:"featuredonly";s:18:"setting-more_posts";s:8:"infinite";s:19:"setting-entries_nav";s:8:"numbered";s:19:"setting-shop_layout";s:12:"sidebar-none";s:27:"setting-shop_archive_layout";s:12:"sidebar-none";s:23:"setting-products_layout";s:5:"grid4";s:29:"setting-shop_masonry_disabled";s:2:"on";s:27:"setting-product_post_gutter";s:6:"gutter";s:23:"setting-products_slider";s:6:"enable";s:30:"setting-shop_products_per_page";s:2:"12";s:46:"setting-default_product_index_image_post_width";s:3:"262";s:47:"setting-default_product_index_image_post_height";s:3:"287";s:29:"setting-single_product_layout";s:12:"sidebar-none";s:47:"setting-default_product_single_image_post_width";s:3:"520";s:48:"setting-default_product_single_image_post_height";s:3:"574";s:30:"setting-related_products_limit";s:1:"3";s:32:"setting-product_description_type";s:4:"long";s:21:"setting-wishlist_page";s:3:"375";s:18:"setting-cart_style";s:8:"dropdown";s:25:"setting-cart_show_seconds";s:4:"1000";s:25:"setting-img_php_base_size";s:5:"large";s:27:"setting-global_feature_size";s:5:"blank";s:22:"setting-link_icon_type";s:9:"font-icon";s:32:"setting-link_type_themify-link-0";s:10:"image-icon";s:33:"setting-link_title_themify-link-0";s:7:"Twitter";s:31:"setting-link_img_themify-link-0";s:109:"https://themify.me/demo/themes/shoppe-fashion/wp-content/themes/themify-shoppe/themify/img/social/twitter.png";s:32:"setting-link_type_themify-link-1";s:10:"image-icon";s:33:"setting-link_title_themify-link-1";s:8:"Facebook";s:31:"setting-link_img_themify-link-1";s:110:"https://themify.me/demo/themes/shoppe-fashion/wp-content/themes/themify-shoppe/themify/img/social/facebook.png";s:32:"setting-link_type_themify-link-2";s:10:"image-icon";s:33:"setting-link_title_themify-link-2";s:7:"YouTube";s:31:"setting-link_img_themify-link-2";s:109:"https://themify.me/demo/themes/shoppe-fashion/wp-content/themes/themify-shoppe/themify/img/social/youtube.png";s:32:"setting-link_type_themify-link-3";s:10:"image-icon";s:33:"setting-link_title_themify-link-3";s:9:"Pinterest";s:31:"setting-link_img_themify-link-3";s:111:"https://themify.me/demo/themes/shoppe-fashion/wp-content/themes/themify-shoppe/themify/img/social/pinterest.png";s:32:"setting-link_type_themify-link-6";s:9:"font-icon";s:33:"setting-link_title_themify-link-6";s:9:"Instagram";s:32:"setting-link_link_themify-link-6";s:34:"https://www.instagram.com/themify/";s:33:"setting-link_ficon_themify-link-6";s:12:"ti-instagram";s:32:"setting-link_type_themify-link-4";s:9:"font-icon";s:33:"setting-link_title_themify-link-4";s:7:"Twitter";s:32:"setting-link_link_themify-link-4";s:27:"https://twitter.com/themify";s:33:"setting-link_ficon_themify-link-4";s:14:"ti-twitter-alt";s:32:"setting-link_type_themify-link-5";s:9:"font-icon";s:33:"setting-link_title_themify-link-5";s:8:"Facebook";s:32:"setting-link_link_themify-link-5";s:32:"https://www.facebook.com/themify";s:33:"setting-link_ficon_themify-link-5";s:11:"ti-facebook";s:22:"setting-link_field_ids";s:239:"{"themify-link-0":"themify-link-0","themify-link-1":"themify-link-1","themify-link-2":"themify-link-2","themify-link-3":"themify-link-3","themify-link-6":"themify-link-6","themify-link-4":"themify-link-4","themify-link-5":"themify-link-5"}";s:23:"setting-link_field_hash";s:1:"9";s:30:"setting-page_builder_is_active";s:6:"enable";s:41:"setting-page_builder_animation_appearance";s:4:"none";s:42:"setting-page_builder_animation_parallax_bg";s:4:"none";s:46:"setting-page_builder_animation_parallax_scroll";s:6:"mobile";s:44:"setting-page_builder_animation_sticky_scroll";s:4:"none";s:4:"skin";s:7:"fashion";s:13:"import_images";s:2:"on";}<?php $themify_data = unserialize( ob_get_clean() );

	// Fix how "skin" option used to save
	if( isset( $themify_data['skin'] ) ) {
		if ( filter_var( $themify_data['skin'], FILTER_VALIDATE_URL ) ) {
			$parsed_skin = parse_url( $value, PHP_URL_PATH );
			$themify_data['skin'] = basename( dirname( $parsed_skin ) );
		}
	}

	themify_set_data( $themify_data );
	
}
themify_do_demo_import();