<?php

namespace FSVendor\WPDesk\Plugin\Flow\Initialization\Simple;

use FSVendor\WPDesk\Plugin\Flow\Initialization\InitializationStrategy;
use FSVendor\WPDesk\PluginBuilder\BuildDirector\LegacyBuildDirector;
use FSVendor\WPDesk\PluginBuilder\Builder\InfoBuilder;
use FSVendor\WPDesk\PluginBuilder\Plugin\AbstractPlugin;
/**
 * Initialize free plugin
 * - just build it already
 */
class SimpleFreeStrategy implements \FSVendor\WPDesk\Plugin\Flow\Initialization\InitializationStrategy
{
    use HelperInstanceAsFilter;
    use TrackerInstanceAsFilter;
    /** @var \WPDesk_Plugin_Info */
    protected $plugin_info;
    public function __construct(\FSVendor\WPDesk_Plugin_Info $plugin_info)
    {
        $this->plugin_info = $plugin_info;
    }
    /**
     * Initializes and builds plugin
     *
     * @return AbstractPlugin
     */
    public function run()
    {
        $this->prepare_helper_action();
        $this->prepare_tracker_action();
        $builder = new \FSVendor\WPDesk\PluginBuilder\Builder\InfoBuilder($this->plugin_info);
        $build_director = new \FSVendor\WPDesk\PluginBuilder\BuildDirector\LegacyBuildDirector($builder);
        $build_director->build_plugin();
        return $build_director->get_plugin();
    }
}
