<?php
/*
Plugin Name:  Builder Image Pro
Plugin URI:   https://themify.me/addons/image-pro
Version:      1.3.1 
Author:       Themify
Author URI:   https://themify.me
Description:  Builder addon to display cool image effects with overlay animation. It requires to use with the latest version of any Themify theme or the Themify Builder plugin.
Text Domain:  builder-image-pro
Domain Path:  /languages
*/

defined( 'ABSPATH' ) or die( '-1' );

class Builder_Image_Pro {

	public $url;
	private $dir;
	public $version;

	/**
	 * Creates or returns an instance of this class.
	 *
	 * @return	A single instance of this class.
	 */
	public static function get_instance() {
            static $instance = null;
            if($instance===null){
                $instance = new self;
            }
            return $instance;
	}

	private function __construct() {
		$this->constants();
		add_action( 'plugins_loaded', array( $this, 'i18n' ), 5 );
		add_action( 'themify_builder_setup_modules', array( $this, 'register_module' ) );
		add_filter( 'themify_builder_script_vars', array( $this, 'themify_builder_script_vars' ) );
		if(is_admin()){
		    add_filter( 'plugin_row_meta', array( $this, 'themify_plugin_meta'), 10, 2 );
		    add_filter( 'plugin_action_links_' . plugin_basename(__FILE__), array( $this, 'action_links') );
		}
	}

	public function constants() {
		$data = get_file_data( __FILE__, array( 'Version' ) );
		$this->version = $data[0];
		$this->url = trailingslashit( plugin_dir_url( __FILE__ ) );
		$this->dir = trailingslashit( plugin_dir_path( __FILE__ ) );
	}

	public function themify_plugin_meta( $links, $file ) {
		if ( plugin_basename( __FILE__ ) === $file ) {
			$row_meta = array(
			  'changelogs'    => '<a href="' . esc_url( 'https://themify.me/changelogs/' ) . basename( dirname( $file ) ) .'.txt" target="_blank" aria-label="' . esc_attr__( 'Plugin Changelogs', 'builder-image-pro' ) . '">' . esc_html__( 'View Changelogs', 'builder-image-pro' ) . '</a>'
			);
	 
			return array_merge( $links, $row_meta );
		}
		return (array) $links;
	}
	public function action_links( $links ) {
		if ( is_plugin_active( 'themify-updater/themify-updater.php' ) ) {
		    $tlinks = array(
			 '<a href="' . admin_url( 'index.php?page=themify-license' ) . '">'.__('Themify License', 'builder-image-pro') .'</a>',
			 );
		} else {
		    $tlinks = array(
			 '<a href="' . esc_url('https://themify.me/docs/themify-updater-documentation') . '">'. __('Themify Updater', 'builder-image-pro') .'</a>',
			 );
		}
		return array_merge( $links, $tlinks );
	}
	public function i18n() {
		load_plugin_textdomain( 'builder-image-pro', false, '/languages' );
	}

	public function register_module() {
	    Themify_Builder_Model::register_directory( 'templates', $this->dir . 'templates' );
	    Themify_Builder_Model::register_directory( 'modules', $this->dir . 'modules' );
	}

	/**
	 * Load animate.css library when Image Pro module is used in the page
	 *
	 * @since 1.1.3
	 */
	public function themify_builder_script_vars( $vars ) {
		$vars['animationInviewSelectors'][] = '.module.module-pro-image';
		return $vars;
	}
}
Builder_Image_Pro::get_instance();
